<?php


namespace app\wuye\controller;




use app\admin\controller\Common;
use think\facade\Db;
use think\facade\Request;

class Property extends Base
{

    protected $middleware = ['app\middleware\PropertyLoginCheck::class','app\middleware\PropertyAfter::class'];

    //添加|删除 物业工作人员
    public function addWorker() {
        $wid = Request::param('wid');
        $data['property_id'] = Request::param('property_id');
        $data['phone'] = Request::param('phone');
        $data['name'] = Request::param('name');
        $data['nickname'] = Request::param('nickname');
        $id_card = Request::param('id_card');
        if(!isCreditNo($id_card)){
            return $this->returnJson([],'身份证号不正确',400);
        }
        $data['id_card'] =  $id_card;
        $data['job_number'] = Request::param('job_number');
        $data['sex'] = Request::param('sex');
        $data['create_time'] = time();

        if($wid){
            $where['wid'] = $wid;
            $option = Db::name('house_worker')->where($where)->save($data);
        } else{
            $option = Db::name('house_worker')->insert($data);
        }

        if($option) {
            return $this->returnJson([],'success');
        } else {
            return $this->returnJson([],'error',400);
        }
    }

    //删除物业员工
    public function deleteWorker() {
        $where['wid'] = Request::param('wid');
        $del = Db::name('house_worker')->where($where)->delete();
        if($del) {
            return $this->returnJson([],'success');
        } else {
            return $this->returnJson([],'error',400);
        }
    }


    //查看单个物业公司详情
    public function detailProperty() {
        $where['hp.property_id'] = Request::param('property_id');
        $data = Db::name('house_property')->alias("hp")->join('property_admin pa','pa.property_admin_id = hp.property_admin_id')
            ->where($where)
            ->field("hp.*,pa.account,pa.status as status_admin")
            ->find();
        $data = Common::changeField($data);
        return $this->returnJson($data,'success');

    }


    //修改物业公司基本信息
    public function changeProperty() {
        $property_id = Request::param("property_id");
        $data['property_name']= Request::param("property_name");
        $data['property_phone'] = $save['phone']= Request::param("property_phone");
        $data['property_address'] = Request::param("property_address");
        $data['province_name'] = Request::param("province_name");
        $data['province_id'] = Request::param("province_id");
        $data['city_name'] = Request::param("city_name");
        $data['city_id'] = Request::param("city_id");
        $data['area_name'] = Request::param("area_name");
        $data['area_id'] = Request::param("area_id");
        $data['account_name'] = Request::param("account_name");
        $data['account_account'] = Request::param("account_account");
        $data['account_username'] = Request::param("account_username");
        $save['account'] = Request::param("account");
        $save['create_time'] = $data['create_time'] = time();
        $save['name'] = Request::param("name");
        if(Request::param("password")){
            $save['password'] = md5(Request::param("password"));
        }
        $where['property_id'] = $property_id;
        $op = Db::name('house_property')->where($where)->save($data);
        $property_admin_id = Db::name('house_property')->where($where)->value("property_admin_id");
        $op1 = Db::name('property_admin')->where(['property_admin_id'=>$property_admin_id])->save($save);

        if($op || $op1) {
            return $this->returnJson([],'success');
        } else {
            return $this->returnJson([],'error',400);
        }
    }









}