<?php


namespace app\wuye\controller;



use app\admin\controller\Common;
use think\facade\Db;
use think\facade\Request;

class Index extends Base
{
    protected $middleware = ['app\middleware\PropertyLoginCheck::class','app\middleware\PropertyAfter::class'];
    //添加| 修改 小区
    public function createCommunity() {

        $village_id = Request::param('village_id');
        $data['village_name'] = Request::param('village_name');
        $data['village_address'] = Request::param('village_address');

        $data['property_price'] = Request::param('property_price',0.00);
        $data['water_price'] = Request::param('water_price',0.00);
        $data['electric_price'] = Request::param('electric_price',0.00);
        $data['gas_price'] = Request::param('gas_price',0.00);
        $data['park_price'] = Request::param('park_price',0.00);
        $data['status'] = $add['type'] = 1;
        $data['province_id'] =  Request::param('province_id');
        $data['province_name'] =  Request::param('province_name');
        $data['city_id'] =  Request::param('city_id');
        $data['city_name'] =  Request::param('city_name');
        $data['area_id'] =  Request::param('area_id');
        $data['area_name'] =  Request::param('area_name');
        $add['account'] =Request::param('account');
        $add['phone'] =Request::param('phone');
        $add['name'] =Request::param('name');
        if($village_id) {
            //修改
            if(Request::param('password')){
                $add['password'] = md5(Request::param('password'));
            }
            $op =  Db::name('house_village')->where(['village_id'=>$village_id])->save($data);
            $community_admin_id = Db::name('house_village')->where(['village_id'=>$village_id])->value("community_admin_id");
            $op1 = Db::name('community_admin')->where(['community_admin_id'=>$community_admin_id])->save($add);
            if($op || $op1) {
                return $this->returnJson([],'success');
            } else {
                return $this->returnJson([],'error',400);
            }

        } else {
            $data['property_id'] = Request::param('property_id');
            $data['create_time'] =  $add['create_time'] = time();
            $add['password'] = md5(Request::param('password'));

            //插入小区管理人员表
            Db::startTrans();
            try{
                $add['village_id'] = Db::name('house_village')->insertGetId($data);
                $change['community_admin_id']= Db::name('community_admin')->insertGetId($add);
                Db::name('house_village')->where(['village_id'=>$add['village_id']])->save($change);
                Db::name('house_property')->where(['property_id'=>$data['province_id'] ])->inc('village_num')->update();
                Db::commit();
                return $this->returnJson([],'success');
            }catch(\Exception $e){
                Db::rollback();
                return $this->returnJson([],'error',400);
            }
        }
    }


    //删除小区
    public function deleteVillage() {
        $id = Request::param('village_id');
        $admin_id = Request::param('admin_id');
        if($admin_id != $this->uid) {
            return $this->returnJson([],'账号异常',400);
        }
        $where['village_id'] = $id;
        $del = Db::name('house_village')->where($where)->delete();
        if($del) {
            Db::name('log')->insert(['explain'=>"物业管理员_".$admin_id."删除了小区_".$id,'time'=>date('Y-m-d H:i:s',time())]);
            return $this->returnJson([],'success');
        } else {
            return $this->returnJson([],'error',400);
        }


    }
    //该物业下的小区列表
    public function villageList() {
        $page = Request::param("page",1);
        $where[] = ['ca.type','=',1];
        $where[] = ['hv.property_id','=',Request::param("property_id")];
        $count = Db::name('house_village')->alias("hv")->join('ruer_community_admin ca','ca.community_admin_id = hv.community_admin_id')->where($where)->count();
        $data = Db::name('house_village')->alias("hv")->join('ruer_community_admin ca','ca.community_admin_id = hv.community_admin_id')
            ->where($where)
            ->page($page,config("app.limit"))
            ->field("hv.*,ca.account,ca.status as status_admin,ca.phone")
            ->select()->toArray();
        $res['total'] = $count;
        $res['data'] =Common::changeField($data);
        return $this->returnJson($res,'success');

    }








}