<?php


namespace app\shequ\controller;


//车位及车辆管理
use app\common\controller\Common;
use think\facade\Db;
use think\facade\Request;

class Parking extends Base
{
    protected $middleware = ['app\middleware\CommunityLoginCheck::class','app\middleware\CommunityAfter::class'];


    //添加车库
    public function createParkArea() {
        $park_block_id = Request::param('park_block_id');
        $data['village_id'] = $this->village_id;
        $data['name'] = Request::param('name');
        $data['sort_id'] = Request::param('sort_id');
        $data['explain'] = Request::param('explain');
        //修改
        if($park_block_id) {
            $where['park_block_id'] = $park_block_id;
            $operation = Db::name('park_block')->where($where)->update($data);
        } else{
            $data['create_time'] = time();
            $operation = Db::name('park_block')->save($data);
        }
        if($operation) {
            return  $this->returnJson([],'success');
        } else {
            return  $this->returnJson([],'操作失败',400);
        }
    }

    //删除车库
    public function deleteParkArea() {
        $where['village_id'] = $this->village_id;
        $where['park_block_id'] = Request::param('park_block_id');
        //查看该区域下是否有车位
        $is_exit = Db::name('park_car')->where($where)->find();
        if($is_exit) {
            return $this->returnJson([],'该区域下有车位,请先删除车位!',400);
        }
        $del = Db::name('park_block')->where($where)->delete();
        if($del) {
            return $this->returnJson([],'success');
        } else {
            return $this->returnJson([],'删除失败',400);
        }
    }


    //车库列表
    public function parkAreaList() {
        $page= Request::param('page',1);
        $where['village_id'] = $this->village_id;
        $res['total'] = Db::name('park_block')->where($where)->count();
        $data = Db::name('park_block')->where($where)->order('sort_id','desc')->page($page,config('app.limit'))->select()->toArray();
        $res['data'] =Common::changeField($data);
        return $this->returnJson($res,'success');
    }


    //添加|修改车位
    public function createCarArea() {
        $park_car_id = Request::param('park_car_id');
        $data['park_block_id'] = Request::param('park_block_id');
        $data['vacancy_code'] = Request::param('vacancy_code');
        $data['village_id'] =  $this->village_id;
        if($data['vacancy_code']) {
            $data['vacancy_id'] =  Db::name('house_vacancy')->where($data)->value('vacancy_id');
        }
        $data['park_code'] = Request::param('park_code');
        $data['sort_id'] = Request::param('sort_id');
        $data['type'] = Request::param('type',1);
        $data['explain'] = Request::param('explain');
        $data['village_id'] = $this->village_id;

        if($park_car_id) { //修改
            $where['park_car_id'] = $park_car_id;
            $is_exit = Db::name('park_car')->where(['village_id'=>$this->village_id,'park_block_id'=>$data['park_block_id'],'park_code'=>$data['park_code']])->where('park_car_id','<>',$park_car_id)->find();
            if($is_exit) {
                return $this->returnJson([],'该编号在当前车库中已存在!',400);
            }
            $operation = Db::name('park_car')->where($where)->save($data);

        } else {
            //判断车位编号是否存在
            $is_exit = Db::name('park_car')->where(['village_id'=>$this->village_id,'park_block_id'=>$data['park_block_id'],'park_code'=>$data['park_code']])->find();
            if($is_exit) {
                return $this->returnJson([],'该编号在当前车库中已存在!',400);
            }

            $data['create_time'] = time();
            $operation = Db::name('park_car')->insertGetId($data);
            //更新房间表
            if(isset($data['vacancy_id'])) {
                Db::name('house_vacancy')->where(['vacancy_id'=>$data['village_id']])->save(['park_car_id'=>$operation]);
            }
        }

        if($operation) {
            return $this->returnJson([],'success');
        } else {
            return $this->returnJson([],'操作失败',400);
        }

    }


    //删除车位
    public function deleteCarArea() {
        $where['village_id'] = $this->village_id;
        $where['park_car_id'] = Request::param('park_car_id');
        $del = Db::name('park_car')->where($where)->delete();
        if($del) {
            return $this->returnJson([],'success');
        } else {
            return $this->returnJson([],'操作失败',400);
        }
    }


    //车位列表
    public function carAreaList() {
        $vacancy = new Vacancy($this->app);
        $page = Request::param('page',1);
        $park_block_id = Request::param('park_block_id');
        $park_code = Request::param('park_code');
        $vacancy_code = Request::param('vacancy_code');
        $where[] = ['pc.village_id','=',$this->village_id];
        if($park_block_id) {
            $where[] = ['pc.park_block_id','=',$park_block_id];
        }
        if($park_code) {
            $where[] = ['pc.park_code','=',$park_code];
        }
        if($vacancy_code) {
            $where[] = ['pc.vacancy_code','=',$vacancy_code];
        }
        $data = Db::name('park_car')->alias('pc')->leftJoin('house_vacancy hv','hv.vacancy_id = pc.vacancy_id')->where($where)->order('sort_id','desc')->page($page,config('app.limit'))
            ->field('pc.*,hv.vacancy_code')
            ->select()->toArray();
        foreach ($data as $k =>$v) {
            $data[$k]['vacancy_address'] = $vacancy->getVacancyAddress($v['vacancy_code']);
        }
        $total = Db::name('park_car')->alias('pc')->leftJoin('house_vacancy hv','hv.vacancy_id = pc.vacancy_id')->where($where)->count();
        $res['total'] = $total;
        $res['data'] = Common::changeField($data);
        return $this->returnJson($res,'success');
    }

    //车位导入模板下载
    public function downloadCarPark() {
        $file_dir = "./formwork/importCarPark.xls";
        $phpExcel = \PHPExcel_IOFactory::load($file_dir);
        $village_id = $this->village_id??1;
        $optionsArr = Db::name('park_block')->where(['village_id'=>$village_id])->column('name');
        $optionsString = implode(',',$optionsArr);//这个是的车库
        if($optionsString){
            for($i=2;$i<3;$i++) {
                $phpExcel->getActiveSheet()->getCell('B'.$i)->getDataValidation()-> setType(\PHPExcel_Cell_DataValidation::TYPE_LIST)
                    -> setErrorStyle(\PHPExcel_Cell_DataValidation::STYLE_INFORMATION)
                    -> setAllowBlank(false)
                    -> setShowInputMessage(true)
                    -> setShowErrorMessage(true)
                    -> setShowDropDown(true)
                    -> setErrorTitle('输入的值有误')
                    -> setError('您输入的值不在下拉框列表内.')
                    -> setPromptTitle('车库')
                    -> setFormula1('"'.$optionsString.'"');; //这一句为要设置数据有效性的单元格

                $phpExcel->getActiveSheet()->getCell('C'.$i)->getDataValidation()-> setType(\PHPExcel_Cell_DataValidation::TYPE_LIST)
                    -> setErrorStyle(\PHPExcel_Cell_DataValidation::STYLE_INFORMATION)
                    -> setAllowBlank(false)
                    -> setShowInputMessage(true)
                    -> setShowErrorMessage(true)
                    -> setShowDropDown(true)
                    -> setErrorTitle('输入的值有误')
                    -> setError('您输入的值不在下拉框列表内.')
                    -> setPromptTitle('车位类型')
                    -> setFormula1('"机动车位,非机动车位"');; //这一句为要设置数据有效性的单元格
            }
        }

        $objWriter = new \PHPExcel_Writer_Excel5($phpExcel);
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="车位导入.xls"');
        header('Cache-Control: max-age=0');
        $objWriter->save("php://output");
    }

    //批量导入车位
    public function  importCarPark() {
        $filePath = Request::param('filePath');

        if(!file_exists($filePath)){
            return $this->returnJson([],'文件不存在!',400);
        }
        $village_id = $this->village_id ?? 1;
        $res = Common::importCarPark($filePath,$village_id);
        if($res['code']==200) {
            return  $this->returnJson([],'success');
        }
    }



    //添加|修改车辆
    public function createCar() {
        $car_id = Request::param('car_id');

        $data['phone'] = Request::param('phone');
        $data['end_time'] = Request::param('end_time');
        $data['name'] = Request::param('name');
        $data['brand'] = Request::param('brand');
        $data['car_color'] = Request::param('car_color');
        $data['brand'] = Request::param('brand');
        $data['license_plate'] = Request::param('license_plate');
        $data['sort_id'] = Request::param('sort_id',1);
        if($car_id) {
            //判断车牌是否存在
            $is_exit = Db::name('car')->where(['license_plate'=>$data['license_plate']])->where('car_id','<>',$car_id)->find();
            if($is_exit) {
                return $this->returnJson([],'系统中已存在该车牌!',400);
            }
            $operation = Db::name('car')->where(['car_id'=>$car_id])->save($data);
        } else {
            $data['create_time'] = time();
            $data['village_id'] = $this->village_id;
            //判断车牌是否存在
            $is_exit = Db::name('car')->where(['license_plate'=>$data['license_plate']])->find();
            if($is_exit) {
                return $this->returnJson([],'系统中已存在该车牌!',400);
            }
            $operation = Db::name('car')->save($data);
        }
        if($operation) {
            return $this->returnJson([],'success');
        } else {
            return $this->returnJson([],'操作失败!',400);
        }


    }

    //删除车辆
    public function deleteCar() {
        $where['village_id'] = $this->village_id;
        $where['car_id'] = Request::param('car_id');
        $del = Db::name('car')->where($where)->delete();

        if($del) {
            return $this->returnJson([],'success');
        } else {
            return $this->returnJson([],'删除失败',400);
        }

    }

    //车辆列表
    public function carList() {

        $where = [];
        $license_plate = Request::param('license_plate');
        $phone = Request::param('phone');
        if($license_plate) {
            $where[] = ['car.license_plate','=',$license_plate];
        }
        if($phone) {
            $where[] = ['car.phone','=',$phone];
        }
        $page = Request::param('page',1);
        $total = Db::name('car')->alias('car')->where($where)->count();
        $data = Db::name('car')->alias('car')->where($where)->order('sort_id','desc')->page($page,config('app.limit'))->select()->toArray();
        $res['total'] = $total;
        $res['data'] = Common::changeField($data);
        return $this->returnJson($res,'success');
    }

    //获取单个车辆信息
    public function detailCar() {
        $where['village_id'] = $this->village_id;
        $where['car_id'] = Request::param('car_id');
        $data = Db::name('car')->where($where)->find();
        return $this->returnJson(Common::changeField($data),'success');

    }

    //获取车位id
    public function getParkCarId($where) {
        $park_car_id = dB::name('park_car')->where($where)->value('park_car_id');

        if($park_car_id) {
            return ['code'=>200,'id'=>$park_car_id];
        } else {
            return ['code'=>400,'msg'=>"该车位编号不存在!"];
        }
    }


    //车辆导入模板下载
    public function downloadCar() {
        $file_path = "./formwork/importCar.xls";
        downloadFile($file_path,"车辆导入.xls");
    }

    //批量导入车辆
    public function importCar() {
        $filePath = Request::param('filePath');
        if(!file_exists($filePath)){
            return $this->returnJson([],'文件不存在!',400);
        }
        $village_id = $this->village_id ?? 1;
        $res = Common::importCar($filePath,$village_id);
        if($res['code']==200) {
            return  $this->returnJson([],'success');
        }

    }







}