<?php


namespace app\shequ\controller;




use app\admin\controller\Common;
use think\facade\Db;
use think\facade\Request;

class Device extends Base
{
    //添加|修改设备
    public function createDevice() {
        $device_id = Request::param('device_id');
        $data['device_name'] = Request::param('device_name');
        $data['device_type'] = Request::param('device_type');
        $data['device_alive'] = Request::param('device_alive');
        $data['device_score'] = Request::param('device_score');
        $data['device_sn'] = Request::param('device_sn');
        $data['village_id'] = $this->village_id;
        $data['build_id'] = Request::param('build_id');
        $data['build_code'] = Request::param('build_code');
        $data['device_direction'] = Request::param('device_direction');
        $data['device_platform'] = Request::param('device_platform');

        if($device_id) {
            $where['device_id'] = $device_id;
            $operate = Db::name('house_face_device')->where($where)->save($data);
        } else {
            $data['create_time'] = time();
            $operate = Db::name('house_face_device')->save($data);
        }
        if($operate) {
            return $this->returnJson([],'success');
        } else {
            return $this->returnJson([],'操作失败!');
        }
    }


    //删除设备
    public function deleteDevice() {
        $where['device_id'] = Request::param('device_id');
        $where['village_id'] = $this->village_id;
        $del = Db::name('house_face_device')->where($where)->delete();
        if($del) {
            return $this->returnJson([],'success');
        } else {
            return $this->returnJson([],'删除失败',400);
        }
    }

    //设备列表
    public function deviceList() {
        $where['village_id'] = $this->village_id;
        $page = Request::param('page',1);
        $total = Db::name('house_face_device')->where($where)->count();
        $data = Db::name('house_face_device')->alias('hfd')->where($where)->order('create_time','desc')
                ->field('hfd.device_id,hfd.build_code,hfd.device_name,hfd.device_type,hfd.device_alive,hfd.device_score,hfd.device_sn,hfd.build_id,hfd.device_direction,hfd.device_platform,hfd.create_time')
                ->page($page,config('app.limit'))->select()->toArray();
        $res['total'] = $total;
        $res['data'] = Common::changeField($data);
        return $this->returnJson($res,'success');
    }

    //获取设备详情
    public function detailDevice(){
        $where['device_id'] = Request::param('device_id');
        $data = Db::name('house_face_device')->where($where)->find();
        return $this->returnJson($data);
    }


}