<?php


namespace app\api\controller;


use app\common\controller\Common;
use think\facade\Db;
use think\facade\Request;

class Payorder extends Base
{
    //查看当前房间下的未缴费的水电物业等,只有业主才能看到记录
    public function payList() {
        $convertArr = $this->convertArr;
        $vacancy_id = Request::param('vacancy_id');
        $uid = $this->uid;

        $page = Request::param('page',1);
        $isPay = Request::param('is_pay',0);
        //不是房主不显示费用明细
        $isOwner = Db::name('house_user_bind')->where(['uid'=>$uid,'vacancy_id'=>$vacancy_id])->find();
        if($isOwner['type'] != 0) {
            return $this->returnJson([]);
        }
        $where['vacancy_id'] = $vacancy_id;
        $where['is_pay'] = $isPay;

        $data = Db::name('cost')->where($where)->order('cost_month','asc')->page($page,config('app.limit'))->select()->toArray();
        foreach ($data as $k => $v){
            $data[$k]['type'] = isset($convertArr[$v['type']]) ? $convertArr[$v['type']]: $v['type'] ;
        }
        $total = Db::name('cost')->where($where)->count();
        $res['total'] = $total;
        $res['data'] = Common::changeField($data);
        return $this->returnJson($res);
    }

    //生成订单
    public function createOrder(){
        $vacancy_id = Request::param('vacancy_id');
        $bind_id = Request::param('bind_id');
        $cost_ids = Request::param('cost_ids');
        $total_money = Request::param('total_money',0);
        //验证物业费订单是否是连续的
        $where['type'] = 'property';
        $where['is_pay'] = 0;
        $where['vacancy_id'] = $vacancy_id;
        $property_cost_ids =  Db::name('cost')->where($where)->whereIn('cost_id',$cost_ids)->column('cost_id'); //上传的未缴物业费的连续cost_id
        $limit = count($property_cost_ids);
        $cost_property_ids = Db::name('cost')->where($where)->limit($limit)->column('cost_id');

        if($cost_property_ids != $property_cost_ids) {
            return $this->returnJson([],'物业费缴费必须连续!');
        }

        //判断金额是否一致
        unset($where['type']);
        $total = Db::name('cost')->where($where)->whereIn('cost_id',$cost_ids)->sum('pay_money');
        if($total != $total_money) {
            return $this->returnJson([],'支付金额不正确!',400);
        }

        $data['uid'] = $this->uid;
        if(count($cost_ids)>1){
            $data['order_type'] = "多订单收费";
        } else {
            $type =Db::name('cost')->whereIn('cost_id',$cost_ids)->value('type');
            $data['order_type'] = $type;
        }
        $data['order_name'] = "社区收费";
        $data['order_num'] = createOrderNum();
        $data['vacancy_id'] = $vacancy_id;
        $res =  $this->getProperty($data['vacancy_id']);
        if($res['code'] !=200){
            return $this->returnJson([],$res['data'],400);
        }

        $data['property_id'] =$res['data']['property_id'];
        $data['village_id'] =$res['data']['village_id'];
        $data['bind_id'] = $bind_id;
        $data['money'] = $total;
        $data['create_time'] = time();
        $data['cost_ids'] = json_encode($cost_ids);
        $data['money'] = $total;
        $order_id = Db::name('pay_order')->insertGetId($data);
        if($order_id) {
            unset($res);
            $res['order_id'] = $order_id;
            return $this->returnJson($res);
        } else{
            return  $this->returnJson([],'添加失败!',400);
        }

    }

    //根据房间id获取当前的物业id和小区id
    public function getProperty($vacancy_id) {

        $data = Db::name('house_vacancy')->alias('hv')->leftJoin('house_village hvi','hvi.village_id = hv.village_id')->where(['hv.vacancy_id'=>$vacancy_id])->field('hvi.village_id,hvi.property_id')->find();

        if($data){
            return ['code'=>200,'data'=>$data];
        } else {
            return ['code'=>400,'data'=>'数据错误!'];
        }
    }

    //生成支付参数
    public function createPaySign() {
        $order_id = Request::param('order_id');
        $total_money = Request::param('total_money');
        $vacancy_id = Request::param('vacancy_id');
        $pay_type = Request::param('pay_type','alipay'); //weixin|alipay
        if(empty($order_id)) {
            return $this->returnJson([],'订单未找到!',400);
        }
        if($this->checkOrder($order_id,$total_money,$vacancy_id)){
            $orderInfo = Db::name('pay_order')->where(['order_id'=>$order_id])->find();
            //支付宝支付
            if($pay_type =='alipay') {
                $param['out_trade_no'] = $orderInfo['order_num'];
                $param['subject'] = $orderInfo['order_name'];
                $param['total_amount'] = floatval($orderInfo['money']);
                $res= $this->getAliPaySign($param);
            //微信支付
            } else {
                $param['order_id'] = $orderInfo['order_id'];
                $param['total_money'] = $orderInfo['money'];
                $param['order_name'] = $orderInfo['order_name'];
                $param['order_num'] = $orderInfo['order_num'];
                $res= $this->getWeiXinPaySign($param);
            }
            return $this->returnJson($res);
        } else {
            return $this->returnJson([],'非法的订单信息!',400);
        }
    }


    //获取支付宝支付参数
    public function getAliPaySign($param) {
        require_once "../extend/aliPay/AopClient.php";
        require_once "../extend/aliPay/request/AlipayTradeAppPayRequest.php";
        $aop = new \AopClient();
        $aop->gatewayUrl = 'https://openapi.alipay.com/gateway.do';
        $aop->appId = config('app.pay_alipay_appid');
        $aop->rsaPrivateKey = config('app.pay_alipay_merchant_private_key');
        $aop->alipayrsaPublicKey = config('app.pay_alipay_public_key');
        $aop->apiVersion = '1.0';
        $aop->signType = config('app.pay_alipay_sign_type');
        $aop->postCharset = 'utf-8';
        $aop->format = 'json';
        $request = new \AlipayTradeAppPayRequest();
        $request->setNotifyUrl(config('app.notifyurl'));
        $request->setBizContent(json_encode($param));
        $response = $aop->sdkExecute($request);
        return $response;
    }


    //获取微信支付参数
    public function getWeiXinPaySign($param) {
        require_once "../extend/weixin/Weixin.php";
        $configArr = config('app.weixinPay');
        $configArr['notifyurl'] = config('app.notifyurl');
        $weixin = new \Weixin($param,$configArr);
        return $weixin->pay();

    }

    //检查订单是否合法
    public function checkOrder($order_id,$total_money,$vacancy_id) {
        $where['order_id'] = $order_id;
        $where['uid'] = $this->uid;
        $where['vacancy_id'] = $vacancy_id;
        $money = Db::name('pay_order')->where($where)->value('money');
        if($money != $total_money) {
            return false;
        }
        return true;
    }






}