<?php


namespace app\api\controller;

use app\common\controller\Common;
use app\BaseController;
use Firebase\JWT\JWT;
use think\facade\Db;
use think\facade\Request;

class Login extends BaseController
{
    //用户登入
    public function login(){
        $phone = Request::param('phone');
        $password = md5(Request::param('password'));
        $code = Request::param('code');

        if($code) {
            //验证短信验证码是否正确
            if(Common::rightCode($phone,$code)){
                $userInfo = Db::name('user')->where(['phone'=>$phone])->find();
                if($userInfo) {
                    $uid = $userInfo['uid'];
                } else {
                    //注册
                    $data['phone'] = $phone;
                    $data['nickname'] = substr_replace($phone,"*",3,5);
                    $data['create_time'] =$data['last_time']=time();
                    $data['add_ip'] = $data['last_ip'] = request()->ip();
                    $uid= Db::name('user')->insertGetId($data);
                }
                Common::synUserData($uid,$phone); //返回用户的绑定的房间
                $token['uid']= $uid;
                $token['time']= date('Y-m-d H:i');
                $token = JWT::encode($token,config('app.jwt_key'));  //根据参数生成了 token
                $res['token'] = $token;
                $res['uid'] = $uid;
                $res['phone'] = $phone;
                return $this->returnJson($res);
            } else{
                return $this->returnJson([],'验证码不正确!','400');
            }
        }

        if($password){
            $where['password'] = $password;
            $where['phone'] = $phone;
            $userInfo = Db::name('user')->where($where)->find();
            if($userInfo){
                //更该登入信息
                $data['last_time']=time();
                $data['last_ip'] = request()->ip();
                Db::name('user')->where(['phone'=>$phone])->save($data);
                $token['uid']= $userInfo['uid'];
                $token['time']= date('Y-m-d H:i');
                $token = JWT::encode($token,config('app.jwt_key'));  //根据参数生成了 token
                $res['token'] = $token;
                $res['uid'] = $userInfo['uid'];
                $res['phone'] = $phone;
                Common::synUserData($userInfo['uid'],$phone);
                return $this->returnJson($res,200);
            } else {
                return $this->returnJson([],'密码不正确!','400');
            }
        }

        return $this->returnJson([],'参数错误,请检查!','400');

    }

    //发送短信验证码
    public function sendCode() {

        $phone = Request::param('phone');
        $temp_id = 165103;
        $temp_para['code'] = createPhoneCode(6);
        $client = new \JSMS('7cb29ca79f936510847b7bc6', '8b1c955df362e317b987554c');
        $res=$client->sendMessage($phone, $temp_id, $temp_para);
        if($res['http_code'] ==200) {
            $data['expires_time'] = time() + 300;
            $data['code'] =   $temp_para['code'] ;
            $data['phone'] = $phone;
            //先删除该手机号的验证码数据,
            Db::name('send_code')->where(['phone'=>$phone])->delete();
            Db::name('send_code')->insert($data);
            return $this->returnJson([]);
        } else {
            $this->returnJson([],'短信验证码发送失败','400');
        }
    }



}