<?php
namespace app\api\controller;


use app\common\controller\Common;
use app\BaseController;
use think\facade\Db;
use think\facade\Request;

class Index  extends Base
{
    public function index() {


        return "这是我请求的内容";
    }

    //建筑列表
    public function buildList() {
        $where['lb.village_id'] = Request::param('village_id');
        $parent_id = Request::param('parent_id',0);
        $where['lb.parent_id'] = $parent_id;
        //检查当前的parent_id是否是最下的一个建筑了,如果是,则查询该下面的房屋
        if($parent_id != 0) {
            $layout_id = Request::param('layout_id');
            $listInfo = Db::name('layout_list')->where(['layout_id'=>$layout_id])->field('code,level')->find();
            $level = $listInfo['level']-1;
            $listArr = explode('-',$listInfo['code']);
            $name = array_pop($listArr);
            $is_last = Db::name('layout_build')->where(['layout_build_id'=>$parent_id,'level'=>$level])->find();
            if($is_last){ //查找房间
                $data = Db::name('house_vacancy')->where(['parent_id'=>$parent_id])->field('vacancy_id,vacancy_code')->select()->toArray();
                foreach ($data as $k => $v) {
                    $vacancyArr = explode('-',$v['vacancy_code']);
                    $code =  array_pop($vacancyArr);
                    $data[$k]['code_name'] = $code.$name;
                }
            } else{
                $data = $this->getBuildInfo($where);
            }
        } else {
            $data = $this->getBuildInfo($where);
        }

        return $this->returnJson($data);
    }

    //获取建筑信息
    public function getBuildInfo($where) {
        if(Request::param('layout_id')) {
            $where['lb.layout_id'] = Request::param('layout_id');
        }
        $data = Db::name('layout_build')->alias('lb')->leftJoin('layout_list ll','ll.layout_id = lb.layout_id')->where($where)->order(['lb.layout_id'=>'asc','lb.sort_id'=>'desc'])
            ->field("lb.layout_build_id,lb.layout_id,lb.code,lb.level,lb.village_id,ll.code as list_code")
            ->select()
            ->toArray();
        foreach ($data as $k =>$v) {
            $data[$k]['code_name'] = $v['code'].explode('-',$v['list_code'])[$v['level']-1];
        }

        return $data;
    }


    //获取单个房间基本信息
    public function getVacancyInfo() {
        $vacancy_id = Request::param('vacancy_id');
        $data = Db::name('house_vacancy')->alias('hv')
                ->Join('house_village hvi','hvi.village_id = hv.village_id')
                ->Join('house_user_bind hub','hub.vacancy_id = hv.vacancy_id')
                ->where(['hv.vacancy_id'=>$vacancy_id])
                ->field('hv.vacancy_code,hv.village_id,hv.parent_id,layout_id,hvi.village_name,hvi.village_address,hvi.province_name,hvi.city_name,hvi.area_name')
                ->find();
        $data['vacancy_address'] = Common::getVacancyAddress($data['vacancy_code'],$data['layout_id']);
        $data['vacancyOwnerInfo'] = Common::getOwnerInfo($vacancy_id); //物业信息
        $data['getUserBindType'] = Common::getUserBindType();
        $data['getFamilyBindType'] = Common::getFamilyBindType();
        return $this->returnJson($data);

    }


    //常用电话
    public function commonPhone() {
        $village_id = Request::param('village_id');
        $where['village_id'] = $village_id;
        $where['status'] = 1;
        $data = Db::name('village_phone')->where($where)->order(['is_on_call_phone'=>'desc','sort'=>'desc'])->select()->toArray();
        return $this->returnJson($data);
    }






}