<?php


namespace app\wuye\controller;


use app\admin\controller\Common;
use think\facade\Db;
use think\facade\Request;

class Admin extends Base
{
    protected $middleware = ['app\middleware\PropertyLoginCheck::class','app\middleware\PropertyAfter::class'];
    //添加或修改物业管理员
    public function createAdmin() {
        $property_admin_id = Request::param('property_admin_id');

        $data['account'] = Request::param('account');
        if(Request::param('password')){
            $data['password'] = md5(Request::param('password'));
        }
        $data['property_id'] = Request::param('property_id');
        $data['role_id'] = Request::param('role_id');
        $data['phone'] = Request::param('phone');
        $data['status'] = Request::param('status');
        $data['name'] = Request::param('name');
        $data['type'] = Request::param('type',0);
        if($property_admin_id){
            $where['property_admin_id'] = $property_admin_id;
            $opation = Db::name('property_admin')->where($where)->save($data);
        } else {
            $opation = Db::name('property_admin')->insert($data);
        }
        if($opation) {
            return $this->returnJson([],'success');
        } else {
            return $this->returnJson([],'error',400);
        }

    }


    //查看所有的物业管理人员
    public function adminList() {
        $where['pa.property_id'] = Request::param('property_id');
        $page = Request::param('page',1);
        $res['total'] =  Db::name('property_admin')->alias('pa')->where($where)->count();
        $data = Db::name('property_admin')->alias('pa')->join('ruer_property_role pr','pa.role_id = pr.role_id')->where($where)
            ->page($page,config('app.limit'))
            ->field("pa.property_id,pa.property_admin_id,pa.account,pa.status,pa.phone,pa.name,pa.type,pa.role_id,pa.create_time")
            ->select()->toArray();

        $res['data'] = Common::changeField($data);
        return $this->returnJson($res,'success');
    }


    //删除物业管理员
    public function deleteAdmin() {
        $property_admin_id = Request::param('property_admin_id');
        $where['property_admin_id'] = $property_admin_id;
        $opation = Db::name('property_admin')->where($where)->delete();
        if($opation) {
            return $this->returnJson([],'success');
        } else {
            return $this->returnJson([],'error',400);
        }
    }

    //查看管理员详情
    public function detailAdmin() {
        $property_admin_id = Request::param('property_admin_id');
        $where['property_admin_id']  = $property_admin_id;
        $data = Db::name('property_admin')->alias('pa')->join('ruer_property_role pr','pa.role_id = pr.role_id')->where($where)
            ->field("pa.property_id,pa.property_admin_id,pa.account,pa.status,pa.phone,pa.name,pr.name as role_name,pr.url_ids,pa.type,pa.role_id,pa.create_time")
            ->find();
        if($data) {
            $allNav = Db::name('property_nav')->field("property_nav_id,url,url_name,property_nav_status,parent_id")->select()->toArray();
            $nav = Common::changeNav($data['url_ids'],$allNav,$data['type']);
            $res['adminInfo'] = $data;
            $res['urlInfo'] = $this->getTree($nav,0,'property_nav_id');
            return $this->returnJson($res,'success');
        } else {
            return $this->returnJson([],'success');
        }

    }

    
    //创建|修改角色
    public function createRole() {
        $role_id =  Request::param('role_id');
        $data['property_id'] = Request::param('property_id');
        $data['name'] = Request::param('name');
        $data['status'] = 1;
        $data['type'] = Request::param('type',0); //1表示超级管理,0表示普通的
        $data['url_ids'] = implode(',',Request::param('url_ids',''));

        if($role_id){
            $opation = Db::name('property_role')->where(['role_id'=>$role_id])->save($data);
        } else{
            $data['create_time'] = time();
            $opation = Db::name('property_role')->insert($data);
        }

        if($opation) {
           return $this->returnJson([],'success');
        } else {
            return $this->returnJson([],'error',400);
        }
    }

    //删除角色列表
    public function deleteRole() {
        //1.首先判断当前角色是否有管理员挂钩,如果没有,才能删除
        $where['role_id'] = Request::param('role_id');
        $where['property_id'] = Request::param('property_id');
        $is_exit = Db::name('property_admin')->where($where)->find();
        if($is_exit){
            return $this->returnJson([],'该角色目前已有管理员使用,不能删除',400);
        }
        $del = Db::name('property_role')->where($where)->delete();
        if($del) {
            return $this->returnJson([],'success');
        } else {
            return $this->returnJson([],'error',400);
        }
    }

    //全部角色列表
    public function roleList() {
        $where['property_id'] = Request::param('property_id');
        $page = Request::param('page',1);
        $data = Db::name('property_role')->where($where)->page($page,config('app.limit'))->select()->toArray();
        $total =  Db::name('property_role')->where($where)->count();

        $res['total'] = $total;
        $res['data'] = Common::changeField($data);
        return $this->returnJson($res,'success');
    }


    //查看角色详情角色
    public function detailRole() {

        $where['role_id'] = Request::param('role_id');
        $data =  Db::name('property_role')->where($where)->find();
        $data  = Common::changeField($data);
        $allNav = Db::name('property_nav')->field("property_nav_id,url,url_name,property_nav_status,parent_id")->select()->toArray();
        $res = Common::changeNav($data['url_ids'],$allNav);
        $data['url_ids'] = $this->getTree($res,0,'property_nav_id');
        return $this->returnJson($data,'success');

    }


    //全部导航栏列表
    public  function navList() {
        $data = Db::name('property_nav')->where(['property_nav_status'=>1])->order(['level'=>'asc','sort_id'=>'desc'])->select()->toArray();
        return $this->returnJson($this->getTree($data,0,'property_nav_id'),'success');
    }

    //根据用户的id返回能访问的url
    public function nav_urls() {
        $id = Request::param('admin_id');
        $where['admin.property_admin_id'] = $id;
        $where['admin.status'] = 1;
        $data = Db::name('property_admin')->alias('admin')->leftJoin('property_role ar','ar.role_id = admin.role_id')->where($where)->field('admin.*,ar.url_ids')->find();

        $allNav = Db::name('property_nav')->field("property_nav_id,url,url_name,property_nav_status,parent_id,icon")->where(['property_nav_status'=>1])->select()->toArray();
        $urlsArr = explode(",",$data['url_ids']);

        if($data['type'] !=1 ) {
            foreach($allNav as $k => $v) {
                if(!in_array($v['property_nav_id'],$urlsArr)){
                    unset($allNav[$k]);
                }
            }
        }
        $urlArr = $this->getTree($allNav,0,'property_nav_id');
        return $this->returnJson($urlArr,'success');

    }




}