<?php


namespace app\shequ\controller;



use think\facade\Db;
use think\facade\Request;

class Village extends Base
{
    protected $middleware = ['app\middleware\CommunityLoginCheck::class','app\middleware\CommunityAfter::class'];

    //社区房屋排布编号
    public function arrangementList() {
        $where['village_id'] = Request::param('village_id');
        $data = Db::name('layout_list')->where($where)->select()->toArray();
        return $this->returnJson($data,'success');
    }

    //添加|修改社区排布
    public function createArrangement() {
        $layout_id = Request::param('layout_id');
        $data['village_id'] = $where['village_id'] = Request::param('village_id');
        $data['code'] = Request::param('code');
        $data['name'] = Request::param('name');
        $data['level'] = $where['level'] = count(explode('-',$data['code']));
        if($layout_id) {
            //当前布局下没有房屋,可以修改
            $where['layout_id'] = $layout_id;
            $is_exit = Db::name('layout_build')->where($where)->find();

            if($is_exit) {
                return $this->returnJson([],'已有该布局排布,添加失败',400);
            }

            //检查是否有类似的布局
            unset($where['layout_id']);
            $is_exit = Db::name('layout_list')->where($where)->find();

            if($is_exit){
                return $this->returnJson([],'已有该布局排布,添加失败',400);
            }
            unset($where['level']);
            $change = Db::name('layout_list')->where($where)->save($data);
            if($change) {
                return $this->returnJson([],'success');
            } else {
                return $this->returnJson([],'error',400);
            }
        } else {

            //检查是否有类似的布局
            $is_exit = Db::name('layout_list')->where($where)->find();
            if($is_exit){
                return $this->returnJson([],'已有该布局排布,添加失败',400);
            }
            $add = Db::name('layout_list')->insert($data);
            if($add) {
                return $this->returnJson([],'success');
            } else {
                return $this->returnJson([],'error',400);
            }

        }
    }


    //删除社区排布编号
    public function deleteArrangement() {
        $layout_id =Request::param('layout_id');
        $where['layout_id'] = $layout_id;
        $is_exit = Db::name('layout_build')->where($where)->find();
        if($is_exit){
            return $this->returnJson([],'以用该布局创建了建筑,请先删除建筑,在删除',400);
        }
        $delete = Db::name('layout_list')->where($where)->delete();
        if($delete) {
            return $this->returnJson([],'success',200);
        } else {
            return $this->returnJson([],'error');
        }
    }



}