<?php


namespace app\shequ\controller;



use app\admin\controller\Common;
use think\App;
use think\facade\Db;
use think\facade\Request;

class Admin extends Base
{
    protected $middleware = ['app\middleware\CommunityLoginCheck::class','app\middleware\CommunityAfter::class'];

    //添加或修改小区管理员
    public function createAdmin() {
        $community_admin_id = Request::param('community_admin_id');

        $data['account'] = Request::param('account');
        if(Request::param('password')){
            $data['password'] = md5(Request::param('password'));
        }

        $data['name'] = Request::param('name');
        $data['role_id'] = Request::param('role_id');
        $data['phone'] = Request::param('phone');
        $data['status'] = Request::param('status');
        $data['type'] = Request::param('type',0);
        if($community_admin_id){
            $where['community_admin_id'] = $community_admin_id;
            $where['village_id'] = Request::param('village_id');
            $opation = Db::name('community_admin')->where($where)->save($data);
        } else {
            $data['village_id'] = Request::param('village_id');
            $data['create_time'] = time();
            $opation = Db::name('community_admin')->insert($data);
        }
        if($opation) {
            return $this->returnJson([],'success');
        } else {
            return $this->returnJson([],'error',400);
        }

    }


    //查看所有的小区管理人员
    public function adminList() {
        $where['ca.village_id'] = Request::param('village_id');
        $page = Request::param('page',1);
        $total = Db::name('community_admin')->alias('ca')->where($where)->count();
        $data = Db::name('community_admin')->alias('ca')->leftJoin('ruer_community_role cr','cr.role_id = ca.role_id')->where($where)
            ->field("ca.create_time,ca.community_admin_id,ca.account,ca.status,ca.phone,ca.name,cr.name as role_name,cr.role_id,ca.type")
            ->page($page,config('app.limit'))
            ->select()->toArray();
        $res['total'] = $total;
        $res['data'] = Common::changeField($data);
        return $this->returnJson($res,'success');
    }

    //查看管理员详情
    public function detailAdmin() {
        $where['admin.community_admin_id'] = Request::param('admin_id');
        $data = Db::name('community_admin')->alias('admin')->leftJoin('community_role ar','ar.role_id = admin.role_id')->where($where)
            ->field('admin.phone,admin.role_id,admin.type,admin.community_admin_id,admin.account,admin.status,admin.role_id,admin.name as admin_name,ar.url_ids,ar.name')->find();

        $allNav = DB::name('community_nav')->where(['community_nav_status'=>1])->field('community_nav_id,url,url_name,parent_id')->select()->toArray();

        $urls = Common::changeNav($data['url_ids'],$allNav,$data['type']);

        $urlArr = $this->getTree($urls,0,'community_nav_id');
        $res['adminInfo'] = $data;
        $res['urlInfo'] = $urlArr;
        return $this->returnJson($res,'success');
    }




    //删除小区管理员
    public function deleteAdmin() {
        $property_admin_id = Request::param('admin_id');
        $where['community_admin_id'] = $property_admin_id;
        $opation = Db::name('community_admin')->where($where)->delete();
        if($opation) {
            return $this->returnJson([],'success');
        } else {
            return $this->returnJson([],'error',400);
        }
    }

    //创建|修改角色
    public function createRole() {
        $role_id =  Request::param('role_id');
        $data['village_id'] = Request::param('village_id');
        $data['name'] = Request::param('name');
        $data['status'] = 1;
        $data['url_ids'] = implode(',',Request::param('url_ids'));
        if($role_id){
            $opation = Db::name('community_role')->where(['role_id'=>$role_id])->save($data);
        } else {
            $data['create_time'] = time();
            $opation = Db::name('community_role')->insert($data);
        }
        if($opation) {
            return $this->returnJson([],'success');
        } else {
            return $this->returnJson([],'error',400);
        }
    }


    //删除角色列表
    public function deleteRole() {
        //1.首先判断当前角色是否有管理员挂钩,如果没有,才能删除
        $where['role_id'] = Request::param('role_id');
        $where['village_id'] = Request::param('village_id');
        if($where['village_id'] != $this->village_id) {
            return $this->returnJson([],'账号异常',400);
        }
        $is_exit = Db::name('community_admin')->where($where)->find();
        if($is_exit){
            return $this->returnJson([],'该角色目前已有管理员赋值,不能删除',400);
        }
        $del = Db::name('community_role')->where($where)->delete();
        if($del) {
            return $this->returnJson([],'success');
        } else {
            return $this->returnJson([],'error',400);
        }
    }

    //全部角色列表
    public function roleList() {
        $where['village_id'] = Request::param('village_id');
        $page = Request::param('page',1);
        $total = Db::name('community_role')->where($where)->count();
        $data = Db::name('community_role')->where($where)->page($page,config('app.limit'))->select()->toArray();
        $res['total'] = $total;
        $res['data'] = $data;
        return $this->returnJson($res,'success');
    }

    //查看角色详情
    public function detailRole() {

        $where['role_id'] = Request::param('role_id');
        $data =  Db::name('community_role')->where($where)->find();
        $data  = Common::changeField($data);
        $allNav = Db::name('community_nav')->field("community_nav_id,url,url_name,community_nav_status,parent_id")->select()->toArray();
        $res = Common::changeNav($data['url_ids'],$allNav);
        $data['url_ids'] = $this->getTree($res,0,'community_nav_id');
        return $this->returnJson($data,'success');
    }


    //全部导航栏列表
    public  function navList() {
        $data = Db::name('community_nav')->where(['status'=>1])->order(['level'=>'asc','sort_id'=>'desc'])->select()->toArray();
        return $this->returnJson($this->getTree($data,0,'community_nav_id'),'success');

    }

    //根据用户的id返回能访问的url
    public function nav_urls() {
        $id = Request::param('admin_id');
        $where['admin.community_admin_id'] = $id;
        $where['admin.status'] = 1;
        $data = Db::name('community_admin')->alias('admin')->leftJoin('community_role ar','ar.role_id = admin.role_id')->where($where)->field('admin.*,ar.url_ids')->find();

        $allNav = Db::name('community_nav')->field("community_nav_id,url,url_name,community_nav_status,parent_id,icon")->where(['community_nav_status'=>1])->select()->toArray();
        $urlsArr = explode(",",$data['url_ids']);

        if(!$data['type'] ==1 ) {
            foreach($allNav as $k => $v) {

                if(!in_array($v['community_nav_id'],$urlsArr)){
                    unset($allNav[$k]);
                }
            }

        }
        $urlArr = $this->getTree($allNav,0,'community_nav_id');
        return $this->returnJson($urlArr,'success');

    }


}