<?php
declare (strict_types = 1);

namespace app\middleware;

use Firebase\JWT\JWT;
use think\facade\Cache;
use think\facade\Request;

class PropertyLoginCheck
{
    /**
     * 处理请求
     *
     * @param \think\Request $request
     * @param \Closure       $next
     * @return Response
     */
    public function handle($request, \Closure $next)
    {
        //查看总管理员是否登入了,如果总管理员登入了可以直接不用物业管理员登入
        if(Request::header('token')) {
            $token =  Request::header('token');
            //判断是否在redis中
            $redis= Cache::store('redis')->handler();
            $decodeData = (array)JWT::decode($token,Config('app.jwt_key'),array("HS256"));

            $p_token= $redis->get("property_tokens_".$decodeData['uid']);  //物业管理员是否登入

            if( !$p_token && $p_token!=$token) {
                return response()->data(json_encode(['code'=>400,'msg'=>'非法的token!!!!']))->code(400);
            }
        } else {
            return response()->data(json_encode(['code'=>400,'msg'=>'token不存在']))->code(401);
        }
        return $next($request);

    }
}
