<?php


namespace app\api\controller;


use app\common\controller\Common;
use think\facade\Db;
use think\facade\Request;

class User extends Base
{
    //获取用户所入住的小区|搜索小区
    public function getUserVillage() {
        $keyword = Request::param('keyword');
        if($keyword) { //如果有关键字就搜索关键字的小区
            $villages = Db::name('house_village')->where('village_name','like','%'.$keyword.'%')->field('village_name,village_id')->select()->toArray();
            $res=[];
            foreach ($villages as $k =>$v) {
                $res[$k]['village_name'] = $v['village_name'];
                $res[$k]['vacancy'] = Common::getVacancy($v['village_id'],$this->uid);
            }
        } else { //没有就展示已入住的小区
            $where['hub.uid'] = $this->uid;
            $where['hub.status'] = 1;
            $village_ids = DB::name('house_user_bind')->alias('hub')->where($where)->column('village_id');
            $village_name = Db::name('house_village')->whereIn('village_id',$village_ids)->column('village_name','village_id');
            $res=[];
            foreach ($village_ids as $k =>$v) {
                $res[$k]['village_name'] = $village_name[$v];
                $res[$k]['vacancy'] = Common::getVacancy($v,$this->uid);
            }
        }
        return $this->returnJson($res);
    }

    //修改|忘记密码
    public function changePassword() {
        if(request()->isPost()) {
            $original_password  = md5(Request::param('original_password'));
            $new_password  = md5(Request::param('new_password'));
            $code  = Request::param('code');
            $phone  = Request::param('phone');
            if($code){
                if(Common::rightCode($phone,$code)){
                    $change = Db::name('user')->where(['uid'=>$this->uid,'phone'=>$phone])->save(['password'=>$new_password]);
                    if($change){
                        return $this->returnJson([]);
                    } else {
                        return $this->returnJson([],'修改失败',400);
                    }
                } else {
                    return $this->returnJson([],"验证码不正确",400);
                }
            } else {
                //验证原密码是否正确
                $is_exit = Db::name('user')->where(['uid'=>$this->uid,'phone'=>$phone,'password'=>$original_password])->find();
                if($is_exit) {
                    $change = Db::name('user')->where(['uid'=>$this->uid,'phone'=>$phone])->save(['password'=>$new_password]);
                    if($change){
                        return $this->returnJson();
                    } else {
                        return $this->returnJson([],'修改失败',400);
                    }
                } else {
                    return $this->returnJson([],'验证码不正确',400);
                }
            }
        } else {
            return $this->returnJson([],'请求方式不正确',400);
        }
    }

    //用户设置密码
    public function setPassword() {
        $data['password'] = md5(Request::param('password'));
        $save = Db::name('user')->where(['uid'=>$this->uid])->save($data);
        if($save) {
            return $this->returnJson();
        } else {
            return $this->returnJson([],'','111111');
        }
    }

    //用户绑定房间
    public function userBindVacancy(){
        $data['type'] = Request::param('type');
        $village_id = Request::param('village_id');
        $vacancy_id =  Request::param('vacancy_id');
        $data['vacancy_id'] = $vacancy_id;
        $data['name'] = Request::param("name");
        $data['phone'] = Request::param("phone");
        $data['village_id'] = $village_id;
        $is_exit = Common::getOwnerInfo($vacancy_id);
        $data['id_card'] = Request::param("id_card");
        $data['uid'] = $this->uid;
        $data['status'] = 2;
        $data['create_time'] = time();
        $data['memo'] = Request::param('memo');
        $data['emer_user'] = Request::param('emer_user');//紧急联系人
        $data['emer_phone'] = Request::param('emer_phone'); //紧急联系人电话
        //查看当前手机号是否重复绑定当前房间,一个房间对应的一个手机号只能有一种身份
        $is_only = Db::name('house_user_bind')->where(['village_id'=>$village_id,'vacancy_id'=>$vacancy_id,'phone'=>$data['phone']])->where('status',"<>",3)->find();
        if($is_only){
            return $this->returnJson([],'用户已绑定房间!',400);
        }
        if($data['type'] == 0) { //申请业主不需要填写业主后四位手机号
            //检查该房间是否有房主绑定
            if(!empty($is_exit)){
                return $this->returnJson([],'该房间下已有业主!',);
            }
            $save['id_card'] = $data['id_card'];
            $save['name'] = $data['name'];
            $save['phone'] = $data['phone'];
            $save['uid'] = $data['uid'];
            //修改房间的信息
            Db::name('house_vacancy')->where(['vacancy_id'=>$vacancy_id])->save($save);
        }else{
            if(empty($is_exit)){
                return $this->returnJson([],'该房间未绑定业主,不能绑定租客!',);
            }
            $ownerPhone = $is_exit['phone'];
            $phone_num = Request::param('phone_num');
            if($phone_num != substr($ownerPhone,7)){
                return $this->returnJson([],'业主后四位手机号不正确!');
            }
        }
        $add = Db::name('house_user_bind')->save($data);
        if($add) {
            return $this->returnJson([],'申请成功,等待审核!',200);
        } else {
            return $this->returnJson([],'申请失败,请重试!',400);
        }

    }

    //用户申请解绑
    public function userUnBind(){
        $where['house_user_bind_id'] = Request::param('house_user_bind_id');
        $where['uid'] = $this->uid;
        $save['status'] = 4;
        $change =Db::name('house_user_bind')->where($where)->save($save);
        if($change) {
            return $this->returnJson([],'申请成功!');
        } else {
            return $this->returnJson([],'申请失败!',400);
        }
    }


    //查看所有的房间,如果是业主,展示房间下的所有租客或家属
    public function getUserVacancy() {
        $uid = $this->uid;
        $where['hub.uid'] = $uid;
        $data = Db::name('house_user_bind')->alias('hub')
                ->leftJoin('house_vacancy hv','hv.vacancy_id = hub.vacancy_id')
                ->leftJoin('house_village hvi','hvi.village_id = hub.village_id')
                ->where($where)->whereIn('hub.status',[1,2,4])
                ->field('hub.type,hub.house_user_bind_id,hub.vacancy_id,parent_id,hv.vacancy_code,hv.layout_id,hv.name,hv.phone,hvi.village_name')
                ->select()->toArray();
        foreach ($data as $k =>$v) {
            $data[$k]['vacancy_address'] = Common::getVacancyAddress($v['vacancy_code'],$v['layout_id']);
            if($v['type'] ==0) {
                //如果是业主身份,查找下面的租客或家属等
                $data[$k]['myTenant'] = Db::name('house_user_bind')->where(['vacancy_id'=>$v['vacancy_id']])->whereIn('type',[1,2,3])->field('name,phone,status')->select()->toArray();
            }else{
                //如果是租客身份,查找所属业主
                $data[$k]['myOwner'] = Db::name('house_user_bind')->where(['vacancy_id'=>$v['vacancy_id'],'type'=>0,'status'=>1])->field('name,phone,status')->find();
            }

        }
        return $this->returnJson($data);
    }


    //用户添加车辆
    public function addCar() {
        $uid = $this->uid;
        $car_id = Request::param('car_id');
        $data['phone'] = Db::name('user')->where(['uid'=>$uid])->value('phone');
        $data['name'] = Request::param('name');
        $data['brand'] = Request::param('brand');
        $data['car_color'] = Request::param('car_color');
        $data['license_plate'] = Request::param('license_plate');
        $data['sort_id'] = Request::param('sort_id',1);
        $data['uid'] = $uid;
        $data['village_id'] = Request::param('village_id');
        if($car_id) {
            //判断车牌是否存在
            $is_exit = Db::name('car')->where(['license_plate'=>$data['license_plate']])->where('car_id','<>',$car_id)->find();
            if($is_exit) {
                return $this->returnJson([],'系统中已存在该车牌!',400);
            }
            $operation = Db::name('car')->where(['car_id'=>$car_id])->save($data);
        } else {
            $data['create_time'] = time();
            //判断车牌是否存在
            $is_exit = Db::name('car')->where(['license_plate'=>$data['license_plate'],'village_id'=>$data['village_id']])->find();
            if($is_exit) {
                return $this->returnJson([],'系统中已存在该车牌!',400);
            }
            $operation = Db::name('car')->save($data);
        }
        if($operation) {
            return $this->returnJson([],'success');
        } else {
            return $this->returnJson([],'操作失败!',400);
        }


    }



}