<?php


namespace app\admin\controller;


use think\facade\Request;
use think\facade\Db;

class Order extends Base
{
    protected $middleware = ['app\middleware\AdminLoginCheck::class','app\middleware\AdminAfter::class'];

    //流水管理
    public function orderList(){

        $page = Request::param('page',1);
        $where= [];
        if(Request::param('property_name')) {
            $property_name = Request::param('property_name');
            $where[] = ['hp.property_name','like','%'.$property_name.'%'];
        }
        if(Request::param('village_name')) {
            $village_name = Request::param('village_name');
            $where[] = ['hv.village_name','like','%'.$village_name.'%'];
        }
        $rest = Common::getWithDrawList($where,$page);
        $res['total'] = $rest['total'];
        $res['data'] = Common::changeField($rest['data']);
        return $this->returnJson($res,'success');

    }

    //查看流水详情
    public function detailOrder() {
        $id = Request::param('id');
        $where['id'] = $id;
        $rest =  Common::getWithDrawDetail($where);
        if(!$rest) {
            return $this->returnJson([],'暂未获取到任何数据',400);
        }
        $res['data'] = $rest['data'];
        $res['orderInfo'] = Common::changeField($rest['orderInfo'],['create_time','pay_time']);
        return $this->returnJson($res,'success');
    }


}