<?php


namespace app\admin\controller;



use think\facade\Db;
use think\facade\Request;

class Common extends Base
{
    //获取省市区
    public  function getArea() {
        $where['area_pid'] = Request::param('area_id',0);
        $data = Db::name('area')->where($where)->field("area_id,area_name")->select()->toArray();
        return $this->returnJson($data,'success');
    }

    //通过id获取地区名称
    public  function getName($id) {
        $where['area_id'] = $id;
        return Db::name('area')->where($where)->value('area_name');
    }

    //查看所有的银行列表
    public function bankAccountList() {

        $data = Db::name("bank_account")->select()->toArray();

        return $this->returnJson($data,'success');

    }

    //对返回的数据进行转换
    public static function changeField($data,$field="create_time") {
        if(empty($data)) {
           return $data;
        }
        foreach($data as $k =>$v) {
            if(is_array($v)) {
                if(is_array($field)) {
                    foreach ($field as $value) {
                        $data[$k][$value] = date('Y-m-d H:i:s',$v[$value]);
                    }
                } else {
                    $data[$k][$field] = date('Y-m-d H:i:s', $v[$field]);
                }
            } else {
                if(is_array($field)) {
                    foreach ($field as $value) {
                        if(isset($data[$value])){
                            $data[$value] = date('Y-m-d H:i:s',$data[$value]);
                        }
                    }
                    break;
                } else {
                    if(isset($data[$field])) {
                        $data[$field] = date('Y-m-d H:i:s', $data[$field]);
                    }
                    break;
                }
            }
        }

        return $data;
    }

    /**
     * @param $url_ids string 1,2,3
     * @param $navAl array
     * @param $type int 1 所有都赋值,0 给特定的赋值
     */
    public  static function changeNav($url_ids,$navAl,$type=0) {
        $urlsArr = explode(",",$url_ids);
        if($type==1 ) {
            return $navAl;
        } else {
            foreach($navAl as $k =>$v ) {
                $navAl[$k]['is_power'] =0 ;
                if(isset($v['property_nav_id']) && !in_array($v['property_nav_id'],$urlsArr)) {
                    unset($navAl[$k]) ;
                }
                if(isset($v['community_nav_id']) && !in_array($v['community_nav_id'],$urlsArr)) {
                    unset($navAl[$k]);
                }
                if(isset($v['admin_nav_id']) && !in_array($v['admin_nav_id'],$urlsArr)) {
                    unset($navAl[$k]);
                }
            }
        }
        return $navAl;
    }

    //获取流水详情,village_money_list表
    public static function getWithDrawDetail($where) {
        $data = Db::name('village_money_list')->alias('ml')
            ->leftJoin('house_village hv','ml.village_id = hv.village_id')
            ->leftJoin('house_property hp','hp.property_id = ml.property_id')
            ->where($where)
            ->field("ml.*,hv.village_name,hp.property_name")
            ->find();

        if($data) {
            $where_one['order_id'] = $data['order_id'];
            switch ($data['table_name']) {
                case "pay_order" :

                    $orderInfo = Db::name('pay_order')->alias('po')
                        ->leftJoin('house_vacancy hv', 'hv.vacancy_id = po.vacancy_id')
                        ->leftJoin('user u', 'po.uid = u.uid')
                        ->field('po.*,hv.vacancy_address,u.phone,u.nickname')
                        ->where($where_one)
                        ->find();
                    break;
                case "withdraw_order":
                    $orderInfo = Db::name('withdraw_order')
                        ->where($where_one)->find();
                    break;
                default:
                    return false;
            }

            return ['data' => $data, 'orderInfo' => $orderInfo];
        } else {
            return false;
        }
    }


    //获取流水列表
    public static function getWithDrawList($where,$page) {
        $count = Db::name('village_money_list')->alias('ml')
            ->leftJoin('house_village hv','ml.village_id = hv.village_id')
            ->leftJoin('house_property hp','hp.property_id = ml.property_id')
            ->where($where)->count();

        $data = Db::name('village_money_list')->alias('ml')
            ->leftJoin('house_village hv','ml.village_id = hv.village_id')
            ->leftJoin('house_property hp','hp.property_id = ml.property_id')
            ->where($where)
            ->field("ml.id,ml.type,ml.total_money,ml.income,ml.create_time,ml.now_village_money,ml.now_property_money,hv.village_name,hp.property_name")
            ->order('ml.create_time','desc')
            ->page($page,config('app.limit'))->select()->toArray();

        return ['total'=>$count,'data'=>$data];
    }







}