<?php


namespace app\admin\controller;

//admin管理人员列
use think\facade\Db;
use think\facade\Request;

class Adminuser extends Base
{
    protected $middleware = ['app\middleware\AdminLoginCheck::class','app\middleware\AdminAfter::class'];

    //创建权限角色
    public function createRole() {
        $data['name'] = Request::param("name");
        $data['status'] = 1;
        $data['create_admin_id'] = Request::param('admin_id');
        $data['create_time'] = time();
        $data['url_ids'] = implode(",",Request::param("url_ids") );

        //查询是否存在相同的name或者url_ids是否相同
        $is_exit= Db::name('admin_role')->where(['name'=>$data['name']])->find();

        if($is_exit) {
            return $this->returnJson([],'角色以存在!');
        }

        $add = Db::name('admin_role')->insert($data);

        if($add) {
            return $this->returnJson([],'角色创建成功');
        } else {
            return $this->returnJson([],'角色创建失败',400);
        }
    }

    //修改角色
    public function changeRole() {
        $where['role_id'] = Request::param('role_id');
        $data['name'] = Request::param("name");
        $data['status'] = Request::param("status");
        $data['url_ids'] = implode(",",Request::param("url_ids"));
        $change = Db::name('admin_role')->where($where)->save($data);
        if($change) {
            return $this->returnJson([],'修改成功');
        } else {
            return $this->returnJson([],'修改失败',400);
        }
    }

    //查看所有的角色列表
    public function roleList() {
        $page = Request::param('page',1);
        $data =  Db::name('admin_role')->page($page,config('app.limit'))->select()->toArray();
        $res['count'] = Db::name('admin_role')->count();
        $res['data'] = Common::changeField($data);

        return $this->returnJson($res,'success');

    }

    //查看具体的角色详情
    public function detailRole() {
        $where['role_id'] = Request::param('role_id');
        $data =  Db::name('admin_role')->where($where)->find();
        $data  = Common::changeField($data);
        $allNav = Db::name('admin_nav')->field("admin_nav_id,url,url_name,admin_nav_status,parent_id")->select()->toArray();
        $urls = Common::changeNav($data['url_ids'],$allNav);

        $data['url_ids'] = $this->getTree($urls,0,'admin_nav_id');
        return $this->returnJson($data,'success');

    }

    //删除角色
    public function deleteRole() {
        //被删除的角色是否已在使用
        $where['role_id'] = Request::param('role_id');
        $is_exit = Db::name('admin')->where($where)->find();
        if($is_exit) {
            return $this->returnJson([],'当前角色以被使用,无法删除',400);
        }
        $dele = Db::name('admin_role')->where($where)->delete();
        if($dele) {
            return $this->returnJson([],'success');
        } else {
            return $this->returnJson([],'error',400);
        }
    }


    //创建|修改 管理员
    public function createAdmin() {

        $admin_id = Request::param('admin_now_id');
        $data['last_operation_admin'] =  $data['create_admin_id'] = Request::param('admin_id'); //当前登入的管理员id
        $data['username'] = Request::param("username");
        $password = Request::param("password");
        if(isset($password)) {
            $data['password'] = md5($password);
        }
        $data['role_id'] = Request::param("role_id");
        $data['name'] = Request::param("name");
        $data['phone'] = Request::param("phone");
        $data['status'] = Request::param("status",1);
        $is_exit = Db::name('admin')->where(['username'=>$data['username']])->find();
        if($admin_id) { //修改
            $where['admin_id'] = $admin_id;
            if($is_exit['admin_id'] != $admin_id) {
                return $this->returnJson([],'管理员账号已存在',400);
            }
            $add = Db::name('admin')->where($where)->save($data);
        } else {
            //添加,是否存在相同的账号
            $data['create_time'] = time();
            $is_exit = Db::name('admin')->where(['username'=>$data['username']])->find();
            if($is_exit) {
                return $this->returnJson([],'管理员账号已存在',400);
            }
            $add = Db::name('admin')->insert($data);
        }
        if($add) {
            return $this->returnJson([],'success');
        } else {
            return $this->returnJson([],'error',400);
        }
    }


    //删除管理员
    public function deleteAdmin() {
        $admin_id = Request::param('admin_id');
        $sum = Db::name('admin')->where(['status'=>1])->count();
        if($sum <= 1) {
            return $this->returnJson([],'最起码需要保留一位管理员',400);
        }
        $where['admin_id'] = $admin_id;
        $dele = Db::name('admin')->where($where)->delete();
        if($dele) {
            return $this->returnJson([],'success');
        } else {
            return $this->returnJson([],'error',400);
        }
    }

    //查看管理员详情
    public function detailAdmin() {
        $where['admin.admin_id'] = Request::param('admin_id');
        $data = Db::name('admin')->alias('admin')->leftJoin('admin_role ar','ar.role_id = admin.role_id')->where($where)
            ->field('admin.name,admin.phone,admin.admin_id,admin.username,admin.status,admin.role_id,ar.url_ids,ar.name,admin.type,ar.name')->find();
        $res['adminInfo'] = $data;
        return $this->returnJson($data,'success');
    }

    //查看管理员列表
    public function adminList() {
        $page = Request::param('page',1);
        $data= Db::name('admin')->page($page,config('app.limit'))->field('admin_id,create_time,username,status,role_id,type,name,phone')->select()->toArray();
        $res['total'] =  Db::name('admin')->count();
        $res['data']  = Common::changeField($data);
        return $this->returnJson($res,'success');

    }

    //根据用户的id返回能访问的url
    public function nav_urls() {
        $id = Request::param('admin_id');
        $where['admin.admin_id'] = $id;
        $where['admin.status'] = 1;
        $data = Db::name('admin')->alias('admin')->leftJoin('admin_role ar','ar.role_id = admin.role_id')->where($where)->field('admin.*,ar.url_ids')->find();
        $allNav = Db::name('admin_nav')->field("admin_nav_id,url,url_name,admin_nav_status,parent_id,icon")->where(['admin_nav_status'=>1])->select()->toArray();
        $urls = Common::changeNav($data['url_ids'],$allNav,$data['type']);
        $urlArr = $this->getTree($urls,0,'admin_nav_id');
        return $this->returnJson($urlArr,'success');

    }






}