<?php
namespace ViPush;

//创建请求体
class Message{

    private $body;

    public function __construct($appsecret='')
    {
        if($appsecret){
            $this->body['requestId'] = $appsecret;
        } else {
            $this->body['requestId'] = \Config::VO_APP_SECRET;
        }

    }

    /**
     * 必须
     * 设置title
     * @param $title
     */
    public function setTitle($title){
        $this->body['title'] = trim($title);

    }
    /**
     * 必须
     * 设置content
     * @param $content
     *
     */
    public function setContent($content){
            $this->body['content'] = trim($content);
    }



    /**
     * 设置提醒级别
     * @param $notifyType 1:无，2:响铃，3:振动，4:响铃和振动
     */
    public function setNotifyType($notifyType=1){
        $this->body['notifyType'] = $notifyType;
    }

    /**
     * @param Array $tag
     */
    public function setTag($tag){
        $this->body['tagExpression']['andTags'] = $tag;
    }

    /**
     * 必须
     * 设置点击通知的动作 1：打开APP首页 2：打开链接 3：自定义 4:打开app内指定页面
     * @return false|string
     */
    public function setSkipType($skipType=1){
        $this->body['skipType'] = $skipType;
    }

    /**
     * 非必要设置
     * 跳转方式,当SkipType为2的时候需要设置
     * @param int $skipContent
     */
    public function setSkipContent($skipContent=1){
        if($this->body['skipType'] == 2 || $this->body['skipType']==3 ){
            $this->body['skipContent'] = $skipContent;
        }
    }

    /**
     * alias 与 regId 两个必须设置一个
     * 设置别名
     * @param $alias
     */
    public function setAlias($alias){
        $this->body['alias'] = $alias;
    }

    /**
     * 设置设备id
     * @param $regId
     */
    public function setRegId($regId){
        $this->body['regId'] = $regId;
    }

    /**
     * 非必要设置
     * 设置消息停留的时间,默认是一天,最长可以7天,单位是秒
     * @param int $s
     */
    public function setTimeToLive($s=86400){
        $this->body['timeToLive'] = $s;
    }

    /**
     * 非必要设置
     * 网络方式 -1：不限，1：wifi下发送，不填默认为-1
     * @param int $networkType
     */
    public function setNetworkType($networkType=1){
        $this->body['networkType'] = $networkType;
    }

    //检查并生成请求参数
    public function build(){
        if(empty($this->body['title'])){
            return "title未设置!";
        }
        if(empty($this->body['content'])){
            return "content未设置!";
        }
        return json_encode(($this->body));
    }




}