<?php
namespace ViPush;

class Application{

    private $appid;
    private $appkey;
    private $appsecret;
    private $url ="https://api-push.vivo.com.cn";

    public function __construct()
    {
        $this->appid = \pushConfig::VO_APP_ID;
        $this->appkey = \pushConfig::VO_APP_KEY;
        $this->appsecret = \pushConfig::VO_APP_SECRET;

    }



    //推送

    /**
     * @param Array $tag
     */
    public function  pushTag($title,$content,$tag){
        $url = $this->url."/message/tagPush";
        $header[] = "Content-Type:application/json;charset=UTF-8";
        $header[] = "authToken:".$this->get_auth_token();

        $data['tagExpression'] = [

            'andTags' => $tag
        ];
        $data['notifyType'] = 4; //1:无，2:响铃，3:振动，4:响铃和振动
        $data['title'] = $title;
        $data['content'] = $content;
        $data['skipType'] = 1; //点击跳转类型 1：打开APP首页 2：打开链接 3：自定义 4:打开app内指定页面
        $data['requestId'] = $this->appsecret;
        return $res = $this->curl_https_post($url,json_encode($data),$header);

    }

    //利用别名推送
    public function pushAlias($body){
        $header[] = "Content-Type:application/json";
        $url = $this->url."/message/send";
        $res = $this->curl_https_post($url,$body,$header);
        return $res;


    }



    //获取auth_token
    public function get_auth_token(){
        $cacheauth = unserialize(file_get_contents(dirname(__FILE__).'/config.txt'));
        if(empty($cacheauth) || ( time()>$cacheauth['expire_time'] )){
            $url = $this->url."/message/auth";
            $header[] = "Content-Type:application/json;charset=UTF-8";
            $data['appId'] = $this->appid;
            $data['appKey'] = $this->appkey;
            $data['timestamp'] = $this->msectime();
            $data['sign'] = md5($data['appId'].$data['appKey'].$data['timestamp'].$this->appsecret);

            $res = $this->curl_https_post($url, json_encode($data),$header);

            $resArr = json_decode($res,true);
            if($resArr['result'] ==0){
                //写入文件
                $in['auth_token'] = $resArr['authToken'];
                $in['expire_time'] = time() + 86000;
                file_put_contents(dirname(__FILE__).'/config.txt', serialize($in));
                return $resArr['authToken'];
            } else {
                return false;
            }

        } else {

            return $cacheauth['auth_token'];
        }

    }

    private function curl_https_post($url, $data = array(), $header = array())
    {

        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 0);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0); // check verify
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5);
        curl_setopt($ch, CURLOPT_TIMEOUT, 5);
        curl_setopt($ch, CURLOPT_POST, 1); // regular post request
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data); // Post submit data
        $ret = @curl_exec($ch);
        if ($ret === false) {
            return null;
        }
        curl_close($ch);
        return $ret;
    }

    //获取毫秒时间戳
    function msectime(){
        list($msec, $sec) = explode(' ', microtime());
        $msectime = (float)sprintf('%.0f', (floatval($msec) + floatval($sec)) * 1000);
        return $msectime;
    }

    public function getConfig(){
        return ['appid'=>$this->appid,'appsecret'=>$this->appkey,'appsecret'=>$this->appsecret];
    }




}