<?php


namespace app\wuye\controller;


use app\BaseController;
use Firebase\JWT\JWT;
use think\App;
use think\facade\Request;

class Base extends BaseController
{

    protected $uid; //物业后台管理员管理员id

    protected $property_id; //物业id

    public function __construct(App $app)
    {

        parent::__construct($app);

        if(config("app.open_check")) { //是否开启验证
            $token =  Request::header('token');
            if(!$token) {
                echo json_encode(['code'=>400,'msg'=>'token不存在']);exit;
            }
            $decodeData = (array)JWT::decode($token,config("app.jwt_key"),array("HS256"));
            $this->uid = $decodeData['uid'];
            $this->property_id = $decodeData['property_id'];

//            $admin = Request::param('admin_id');
//            $property_id = Request::param('property_id');
//
//            if(isset($admin)){ //如果接口传递了admin_id就验证
//                if($admin != $this->uid) {
//                    echo json_encode(['code'=>401,'msg'=>'当前登入账号异常!!!!!']);exit;
//                }
//            }
//            if(isset($property_id)){ //如果接口传递了admin_id就验证
//                if($property_id != $this->property_id) {
//                    echo json_encode(['code'=>401,'msg'=>'当前登入账号异常!!!!!']);exit;
//                }
//            }

        }



    }



}