<?php


namespace app\shequ\controller;



use app\admin\controller\Common;
use think\facade\Db;
use think\facade\Request;

class Village extends Base
{
    protected $middleware = ['app\middleware\CommunityLoginCheck::class','app\middleware\CommunityAfter::class'];

    //社区房屋排布编号
    public function arrangementList() {
        $where['village_id'] = Request::param('village_id');
        $data = Db::name('layout_list')->where($where)->select()->toArray();
        return $this->returnJson($data,'success');
    }

    //添加|修改社区排布
    public function createArrangement() {
        $layout_id = Request::param('layout_id');
        $data['village_id'] = $where['village_id'] = Request::param('village_id');
        $data['code'] = Request::param('code');
        $data['name'] = Request::param('name');
        $data['pic'] = Request::param('pic');
        $data['level'] = $where['level'] = count(explode('-',$data['code']));
        if($layout_id) {
            //当前布局下没有房屋,可以修改
            $where['layout_id'] = $layout_id;
            $is_exit = Db::name('layout_build')->where($where)->find();

            if($is_exit) {
                return $this->returnJson([],'已有该布局排布,添加失败',400);
            }

            //检查是否有类似的布局
            unset($where['layout_id']);
            $is_exit = Db::name('layout_list')->where($where)->find();

            if($is_exit){
                return $this->returnJson([],'已有该布局排布,添加失败',400);
            }
            unset($where['level']);
            $change = Db::name('layout_list')->where($where)->save($data);
            if($change) {
                return $this->returnJson([],'success');
            } else {
                return $this->returnJson([],'error',400);
            }
        } else {

            //检查是否有类似的布局
            $is_exit = Db::name('layout_list')->where($where)->find();
            if($is_exit){
                return $this->returnJson([],'已有该布局排布,添加失败',400);
            }
            $add = Db::name('layout_list')->insert($data);
            if($add) {
                return $this->returnJson([],'success');
            } else {
                return $this->returnJson([],'error',400);
            }

        }
    }


    //删除社区排布编号
    public function deleteArrangement() {
        $layout_id =Request::param('layout_id');
        $where['layout_id'] = $layout_id;
        $is_exit = Db::name('layout_build')->where($where)->find();
        if($is_exit){
            return $this->returnJson([],'以用该布局创建了建筑,请先删除建筑,在删除',400);
        }
        $delete = Db::name('layout_list')->where($where)->delete();
        if($delete) {
            return $this->returnJson([],'success',200);
        } else {
            return $this->returnJson([],'error');
        }
    }


    //查看社区的基本信息
    public function villageInfo() {
        $where['village_id'] = $this->village_id;
        $data =DB::name('house_village')->where($where)
            ->field('village_id,property_price,water_price,electric_price,gas_price,parking_price as park_price,village_logo,village_name,village_address,province_id,province_name,city_id,city_name,area_id,area_name')->find();
        return $this->returnJson($data,'success');

    }

    //修改小区的基本信息
    public function changeVillageInfo(){
        $property_price = Request::param('property_price');
        $water_price = Request::param('water_price');
        $electric_price = Request::param('electric_price');
        $gas_price = Request::param('gas_price');
        $park_price = Request::param('park_price');

        if(!isset($park_price) || !isset($gas_price) || !isset($electric_price) || !isset($water_price) || !isset($property_price)){
            return $this->returnJson([],'费用必传递!',400);
        }

        $where['village_id'] = $this->village_id;

        //查看小区的水电物业费等
        $info = Db::name('house_village')->where($where)->field('property_price,water_price,electric_price,gas_price,parking_price,village_logo')->find();
        //修改了小区的费用
        if($info['property_price'] != $property_price || $info['water_price'] != $water_price || $info['electric_price'] != $electric_price || $info['gas_price'] != $gas_price ||$info['parking_price'] != $park_price ) {
            $save['property_price'] = $property_price;
            $save['water_price'] = $water_price;
            $save['electric_price'] = $electric_price;
            $save['gas_price'] = $gas_price;
            $save['parking_price'] = $park_price;
            Db::startTrans();
            try{
                Db::name('layout_build')->where($where)->save($save);
                DB::name('house_village')->where($where)->save($save);
                Db::commit();
                return $this->returnJson();
            }catch(\Exception $e){
                Db::rollback();
                return $this->returnJson([],'修改失败',400);
            }
        }

        $data['village_name'] = Request::param('village_name');
        $data['village_address'] = Request::param('village_address');
        $data['province_id'] = Request::param('province_id');
        $data['province_name'] = Request::param('province_name');
        $data['city_id'] = Request::param('city_id');
        $data['city_name'] = Request::param('city_name');
        $data['area_id'] = Request::param('area_id');
        $data['area_name'] = Request::param('area_name');
        $data['village_logo'] = Request::param('village_logo');
        $change = DB::name('house_village')->where($where)->save($data);
        if(!$change) {
            return $this->returnJson([], '修改失败', 400);
        }
        return $this->returnJson();

    }

    //banner图添或修改
    public function addBanner() {
        $banner_id =Request::param('banner_id');
        $data['pic'] =Request::param('pic');
        $data['url'] =Request::param('url');
        $data['title'] =Request::param('title');
        $data['sort_id'] =Request::param('sort_id',1);
        if($banner_id){
            $where['banner_id'] = $banner_id;
            $where['village_id'] = $this->village_id;
            $operation = Db::name('village_banner')->where($where)->save($data);
        } else {
            $data['village_id'] = $this->village_id;
            $data['create_time'] = time();
            $operation = Db::name('village_banner')->insert($data);
        }
        if($operation) {
            return $this->returnJson();
        } else {
            return $this->returnJson([],'操作失败!',400);
        }
    }

    //删除banner
    public function deleteBanner() {
        $banner_id =Request::param('banner_id');
        $where['banner_id'] = $banner_id;
        $where['village_id'] = $this->village_id;
        $delete = Db::name('village_banner')->where($where)->delete();
        if($delete) {
            return $this->returnJson();
        } else {
            return $this->returnJson([],'删除失败!',400);
        }
    }

    //banner列表
    public function bannerList(){
        $where['village_id'] = $this->village_id;
        $data =Db::name('village_banner')->where($where)->order(['sort_id'=>'desc','create_time'=>'desc'])->select()->toArray();
        return $this->returnJson(Common::changeField($data));
    }


    //查看具体的banner
    public function detailBanner() {
        $where['banner_id'] = Request::param('banner_id');
        $where['village_id'] = $this->village_id;
        $data = Db::name('village_banner')->where($where)->find();
        if(!$data) {
            $data =[];
        }
        return $this->returnJson($data);
    }






}