<?php


namespace app\shequ\controller;


//关于订单的接口
use app\common\controller\Common;
use think\facade\Db;
use think\facade\Request;

class Order extends Base
{
    protected $middleware = ['app\middleware\CommunityLoginCheck::class','app\middleware\CommunityAfter::class'];
    public function orderList() {

        //流水管理
        $page = Request::param('page',1);
        if(Request::param('income')) {
            $where[] = ['ml.income','=',Request::param('income')];
        }
        $where[] = ['ml.village_id','=',$this->village_id];
        if(Request::param('start_time') && Request::param('end_time') ) {
            $start_time = strtotime(Request::param('start_time'));
            $end_time = strtotime(Request::param('end_time'));
            if($start_time >= $end_time) {
                return $this->returnJson([],'开始时间不能大于结束时间!',400);
            }
            $where[] = ['ml.create_time','between',[$start_time,$end_time]];
        }
        $rest = Common::getWithDrawList($where,$page);
        $res['total'] = $rest['total'];
        $res['data'] = Common::changeField($rest['data']);
        return $this->returnJson($res,'success');

    }

    //查看流水详情
    public function detailOrder() {
        $id = Request::param('id');
        $where['id'] = $id;
        $rest =  Common::getWithDrawDetail($where);
        if(!$rest) {
            return $this->returnJson([],'暂未获取到任何数据',400);
        }
        $res['data'] = $rest['data'];
        $res['orderInfo'] = Common::changeField($rest['orderInfo'],['create_time','pay_time']);
        return $this->returnJson($res,'success');

    }


    //下载水费模板
    public function downloadImportWater(){
        $file_path = "./formwork/importWater.xls";
        downloadFile($file_path,"每月水费导入.xls");
    }

    //批量导入费用
    public function importCost() {
        $filePath = Request::param('filePath');
        $type = Request::param('type');

        if(!in_array($type,['water','gas','electric'])) {
            return  $this->returnJson([],'type类型不正确!',400);
        }
        if(!file_exists($filePath)){
            return $this->returnJson([],'文件不存在!',400);
        }
        $village_id = $this->village_id ?? 1;
        $res = Common::importCost($filePath,$village_id,$type);
        if($res['code']==200) {
            return  $this->returnJson([],'success');
        }
    }

    //下载电费模板
    public function downloadImportElectric(){
        $file_path = "./formwork/importElectric.xls";
        downloadFile($file_path,"每月电费导入.xls");
    }

    //下载燃气费模板
    public function downloadImportGas(){
        $file_path = "./formwork/importGas.xls";
        downloadFile($file_path,"每月燃气费导入.xls");
    }








}