<?php


namespace app\shequ\controller;

//社区新闻模块
use app\common\controller\Common;
use think\facade\Db;
use think\facade\Request;

class News extends  Base
{
    protected $middleware = ['app\middleware\CommunityLoginCheck::class','app\middleware\CommunityAfter::class'];

    //添加 | 修改新闻栏目
    public function createNewsType() {
        $news_type_id = Request::param('news_type_id');
        $data['name'] = Request::param('name');
        $data['sort_id'] = Request::param('sort_id');
        $data['img'] = Request::param('img');
        if($news_type_id) {
            $where['news_type_id'] = $news_type_id;
            $where['village_id'] = $this->village_id;
            $operation = Db::name('news_type')->where($where)->save($data);
        } else{
            $data['village_id'] = $this->village_id;
            $operation = Db::name('news_type')->save($data);
        }
        if($operation) {
            return $this->returnJson([],'success');
        } else {
            return $this->returnJson([],'操作失败!',400);
        }

    }

    //删除新闻栏目
    public function deleteNewsType() {
        $news_type_id = Request::param('news_type_id');
        $where['news_type_id'] = $news_type_id;
        $where['village_id'] = $this->village_id;
        $del = Db::name('news_type')->where($where)->delete();
        //删除相关的所有新闻
        $del1 = Db::name('news')->where($where)->delete();
        if($del || $del1) {
            return $this->returnJson([],'success');
        } else {
            return $this->returnJson([],'删除失败',200);
        }

    }

    //新闻栏目列表
    public function NewsTypeList() {
        $where['village_id'] = $this->village_id;
        $page = Request::param('page',1);
        $data = Db::name('news_type')->where($where)->page($page,config('app.limit'))->order('sort_id','desc')->select()->toArray();
        $total = Db::name('news_type')->where($where)->count();
        $res['total'] = $total;
        $res['data'] = $data;
        return $this->returnJson($res,'success');
    }

    //添加|修改新闻
    public function createNews() {
        $news_id = Request::param('news_id');
        $data['title'] = Request::param('title');
        $data['content'] = Request::param('content');
        $data['author'] = Request::param('author');
        $data['news_type_id'] = Request::param('news_type_id');
        $data['create_time'] = time();
        $data['pic'] = Request::param('pic');
        $data['sort_id'] = Request::param('sort_id',1);
        $data['is_recommend'] = Request::param('is_recommend',0);//是否放首页推荐
        $data['recommend_sort_id'] = Request::param('recommend_sort_id',1);//首页推荐排序id
        $data['village_id'] = $this->village_id;
        if($news_id) {
            $where['news_id'] = Request::param('news_id');
            $add = Db::name('news')->where($where)->save($data);
        } else {
            $add = Db::name('news')->save($data);

        }
        if($add) {
            return $this->returnJson([],'success');
        } else {
            return $this->returnJson([],'error',400);
        }
    }

    //删除新闻
    public function deleteNews() {
        $where['news_id'] = Request::param('news_id');
        $del = Db::name('news')->where($where)->delete();
        if($del) {
            return $this->returnJson([],'success');
        } else {
            return $this->returnJson([],'删除失败!',400);
        }
    }

    //新闻列表
    public function newsList() {
        $page = Request::param('page',1);
        $where[]= ['n.village_id','=',$this->village_id];
        $news_type_id = Request::param('news_type_id');
        $title = Request::param('title');
        if($news_type_id) {
            $where[] = ['n.news_type_id','=',$news_type_id];
        }
        if($title) {
            $where[] = ['n.title','like','%'.$title.'%'];
        }
        $total = Db::name('news')->alias('n')->leftJoin('news_type nt','n.news_type_id = nt.news_type_id')->where($where)->count();
        $data = Db::name('news')->alias('n')->leftJoin('news_type nt','n.news_type_id = nt.news_type_id')->order(['n.sort_id'=>'desc','n.create_time'=>'desc'])
            ->field('n.news_id,n.news_type_id,n.title,n.author,n.create_time,n.sort_id,nt.name')
            ->page($page,config('app.limit'))->where($where)->select()->toArray();
        $res['total'] = $total;
        $res['data'] = Common::changeField($data);
        return $this->returnJson($res,'success');
    }

    //查看新闻详情
    public function detailNews() {
        $news_id = Request::param('news_id');
        $where[] = ['n.news_id','=',$news_id];
        $data = Db::name('news')->alias('n')->leftJoin('news_type nt','n.news_type_id = nt.news_type_id')->where($where)->find();
        return $this->returnJson($data,'success');
    }


    //base图片上传
    public function uploadImgBase64() {
        $dir  = "/upload/village/".$this->village_id."/";
        $base_img = Request::param('base_img');
        $res = uploadImgs($dir,$base_img);
        if($res['code']==200){
            $data['data'] = $res['msg'];
            $data['path'] = $res['path'];
            return $this->returnJson($data);
        } else {
            return $this->returnJson([],$res['msg'],400);
        }
    }

    //file图片上传
    public function uploadImg() {
        $file = request()->file('img');
        $path = '/new/'."village_".$this->village_id;
        $data = Common::uploadImg($file,$path);
        if($data) {
            return $this->returnJson($data,'success');
        } else {
            return $this->returnJson([],'请上传图片文件',400);
        }
    }

    //添加或修改公告
    public function createNotice() {
        $notice_id = Request::param('notice_id');
        $data['title'] = Request::param('title');
        $data['content'] = Request::param('content');
        $data['author'] = Request::param('author');
        $data['create_time'] = time();
        $data['sort_id'] = Request::param('sort_id',1);
        $data['village_id'] = $this->village_id;
        if($notice_id) {
            $where['notice_id'] = $notice_id;
            $add = Db::name('notice')->where($where)->save($data);
        } else {
            $add = Db::name('notice')->save($data);

        }
        if($add) {
            return $this->returnJson([],'success');
        } else {
            return $this->returnJson([],'error',400);
        }

    }

    //删除公告
    public function deleteNotice() {
        $where['notice_id'] = Request::param('notice_id');
        $del = Db::name('notice')->where($where)->delete();
        if($del) {
            return $this->returnJson([],'success');
        } else {
            return $this->returnJson([],'删除失败!',400);
        }
    }

    //查看公告详情
    public function detailNotice() {
        $notice_id = Request::param('notice_id');
        $where['notice_id'] = $notice_id;
        $data = Db::name('notice')->where($where)->find();
        return $this->returnJson(Common::changeField($data),'success');
    }

    //公告列表
    public function noticeList() {
        $where['village_id'] = $this->village_id;
        $page = Request::param('page',1);
        $data = Db::name('notice')->where($where)->field('notice_id,title,author,create_time')->page($page,config('app.limit'))->select()->toArray();
        $total = Db::name('notice')->where($where)->count();
        $res['total'] = $total;
        $res['data'] = Common::changeField($data);
        return $this->returnJson($res);
    }

}