<?php


namespace app\shequ\controller;


use app\BaseController;
use Firebase\JWT\JWT;
use think\App;
use think\facade\Request;

class Base extends BaseController
{

    protected $uid; //社区后台管理员管理员id
    protected $village_id; //小区id

    public function __construct(App $app)
    {

        parent::__construct($app);

        if(config("app.open_check")) { //是否开启验证
            $token =  Request::header('token');
            if(!$token) {
                echo json_encode(['code'=>401,'msg'=>'token不存在']);exit;
            }
            $decodeData = (array)JWT::decode($token,config("app.jwt_key"),array("HS256"));
            $this->uid = $decodeData['uid'];
            $this->village_id = $decodeData['village_id'];

        }



    }



}