<?php
declare (strict_types = 1);

namespace app\middleware;

use Firebase\JWT\JWT;
use think\facade\Cache;
use think\facade\Request;

/**
 * Class Logincheck
 * @package app\middleware
 * admin后台登入后置中间件,有操作之后更新redis缓存过期时间
 */
class AdminAfter
{
    /**
     * 处理请求
     *
     * @param \think\Request $request
     * @param \Closure       $next
     * @return Response
     */
    public function handle($request, \Closure $next)
    {
        $response = $next($request);

        $token =  Request::header('token');
        //判断是否在redis中
        $decodeData = (array)JWT::decode($token,"zhihuishequ",array("HS256"));
        $redis= Cache::store('redis')->handler();
        $keys[] = "admin_tokens_".$decodeData['uid'];
        foreach ($keys as $value){
            if($redis->exists($value)) {
                $redis->EXPIRE($value,3600); //设置过期时间,
            }
        }

        return $response;


    }

}
