<?php


namespace app\common\controller;


use app\BaseController;
use think\facade\Db;

class Timing extends BaseController
{
    //每月的一号生成所有房间的当月的物业费,其他费用后台每月自己添加
    public function createCost() {
        //物业费每月自动生成
        Db::name('house_vacancy')->alias('hv')
            ->leftJoin('layout_build lb','lb.layout_build_id = hv.parent_id' )
            ->field('lb.property_price,hv.property_fee as vacancy_property_price,hv.property_end_time,hv.area,hv.is_inherit,hv.vacancy_id,hv.village_id')
            ->chunk(20,function ($dataAll){

                foreach ($dataAll as $k=>$v) {
                    if(is_null($v['property_end_time'])){
                       continue;
                    }
                    $price = $v['is_inherit'] == 1 ? $v['property_price'] : $v['vacancy_property_price'];
                    $property_end_time = strtotime($v['property_end_time']);
                    $now_time = date('Y-m',time());
                    $now_time_stamp = strtotime($now_time);

                    if($now_time_stamp > $property_end_time) { //生成当前月份与物业结束时间之前的每月费用
                         $data['vacancy_id'] = $v['vacancy_id'];
                         $data['village_id'] = $v['village_id'];
                         $data['type'] = 'property';
                         $res = $this->createDate($v['property_end_time'],$now_time); //返回物业开始时间到结束时间之前的每月时间,array
                         foreach ($res as $val){
                             $data['cost_month'] = $val;
                             //先判断当前月份的物业费是否已存在
                             $is_exit = Db::name('cost')->where($data)->where($data)->find();
                             if($is_exit) {
                                 continue;
                             }
                             $data['area'] = $v['area'];
                             $data['total_month'] = $v['area']*$price;
                             $data['create_time'] = time();
                             $data['price'] = $price;
                             Db::name('cost')->insert($data);
                         }
                    }
                }
            });

    }

    //根据开始时间和结束时间生成中间的月份
   // Y-m;
    public function createDate($start_time,$end_time) {
        $start_time_year = explode('-',$start_time)[0];
        $start_time_month = explode('-',$start_time)[1];
        $end_time_year = explode('-',$end_time)[0];
        $end_time_month = explode('-',$end_time)[1];
        $res =[];
        if($start_time_year==$end_time_year) {
            for($i=$start_time_month;$i<=$end_time_month;$i++) {
                $res[] = $start_time_year."-".$i;
            }
        } else {
            for($i=$start_time_year;$i<=$end_time_year;$i++) {

                if($i == $end_time_year) {
                    for($j=1;$j<=$end_time_month;$j++) {

                        if($j<10){
                            $res[] = $i."-0".$j;
                        } else {
                            $res[] = $i."-".$j;
                        }
                    }
                } elseif($i==$start_time_year) {
                    for($k=$start_time_month;$k<13;$k++) {
                        if($k<10){
                            $res[] = $i."-0".$k;
                        } else{
                            $res[] = $i."-".$k;
                        }
                    }
                } else {
                    for($k=1;$k<13;$k++) {
                        if($k<10){
                            $res[] = $i."-0".$k;
                        } else{
                            $res[] = $i."-".$k;
                        }

                    }
                }
            }
        }

        return $res;
    }
}