<?php
namespace app\common\controller;
use \HwPush\push_admin\Application;
use \app\BaseController;
use think\facade\Db;

$file =   dirname(dirname(dirname(__DIR__)))."/extend/jpush/autoload.php";
require_once $file;
class Jpush extends BaseController
{

    public static $title = "微控云享智慧社区";

    //推送所有的
    public static function push($phone,$content){

        self::push_mi($phone,$content);

        self::push_huwei($phone,$content);

        self::push_oppo($phone,$content);

        self::push_meizu($phone,$content);

        self::push_vivo($phone,$content);

        self::push_jiguang($phone,$content);

    }

    /**
     * mi推送代码测试,已通过
     */
    public static function push_mi($phone,$content){
        $alias = $phone;
        $title = self::$title;
        $desc = $content;
        $sender = new \MiPush\xmpush\Sender();
        $message1 = new \MiPush\xmpush\Builder();
        $message1->title($title);  // 通知栏的title
        $message1->description($desc); // 通知栏的descption
        $message1->passThrough(0);  // 这是一条通知栏消息，如果需要透传，把这个参数设置成1,同时去掉title和descption两个参数
        $message1->extra( \MiPush\xmpush\Builder::notifyForeground, 1); // 应用在前台是否展示通知，如果不希望应用在前台时候弹出通知，则设置这个参数为0
        $message1->notifyId(2); // 通知类型。最多支持0-4 5个取值范围，同样的类型的通知会互相覆盖，不同类型可以在通知栏并存
        $message1->build();
        $sender->broadcast($message1, $alias)->getRaw();
    }


    /**
     * huawei推送
     */
    public static function push_huwei($phone,$content){

        $application = Application::getInstance();
        //设备token
        $device = Db::name('push_device')->where(['phone'=>$phone,'type'=>1])->value('device_id',true);
        $device_token = json_encode($device);
        $title =  self::$title;
        $body = $content;
        $res = $application->pushMsg($title,$body,$device_token);
    }


    /**
     * oppo 推送
     */
    public static function push_oppo($phone,$content){

        $application = new \OPush\Application();
        $title = self::$title;
        $device = Db::name('push_device')->where(['phone'=>$phone,'type'=>2])->column('device_id');
        foreach($device as $v){
            $res = $application->pushTag($title,$content,$v);
        }
    }

    /**
     * meizu 推送
     */
    public static function push_meizu($phone,$content){
        $application = new \MzPush\Application();
        $title = self::$title;
        $res = $application->pushTag($title,$content,$phone);

    }

    /**
     * 极光推送iso测试通过
     */

    public static function push_jiguang($phone,$content){

        $client = new \JPush\Client();
        $alias = $phone;
        //iso是通了的
        $result = $client->push()
            ->setPlatform(array('all'))// 推送的all
            ->addAlias($alias)//
            ->setNotificationAlert($content)
            ->send();

    }


    /**
     * vivo推送
     */

    public static function push_vivo($phone,$content){
        $application = new \ViPush\Application();

        //别名推送
//        $alias = $phone;
//        $message = new \ViPush\Message();
//        $message->setTitle(self::$title);
//        $message->setContent($content);
//        $message->setNotifyType(4);
//        $message->setAlias($alias);
//        $message->setSkipType();
//        $message->setSkipType();
//        $body = $message->build();
//        $res = $application->pushAlias($body);

        //tag推送,测试成功
        $title = self::$title;
        $tag[] = $phone;
        return $res = $application->pushTag($title,$content,$tag);
    }








}
