<?php
namespace  app\api\controller;


use app\common\controller\Common;
use think\facade\Db;
use think\facade\Request;

class News extends Base{

    //新闻分类
    public function newsType() {
      $villate_id  = Request::param('village_id');
      $new_type = Db::name('news_type')->where(['village_id'=>$villate_id])->order('sort_id','desc')->select()->toArray();
      return $this->returnJson($new_type);
    }


    //分类下的新闻列表
    public function newsList() {
        $type_id = Request::param('type_id');
        $page = Request::param('page',1);
        $where['news_type_id'] = $type_id;
        $data = Db::name('news')->where($where)->page($page,config('app.limit'))->order(['sort_id'=>'desc','create_time'=>'desc'])->field('news_id,title,content,create_time,pic')->page($page,config('app.limit'))->select()->toArray();
        foreach ($data as $k => $v) {
            $data[$k]['content'] = mb_substr(strip_tags($v['content']),0,100);
        }
        $res['total'] = Db::name('news')->where($where)->count();
        $res['data'] = Common::changeField($data);
        return $this->returnJson($res);
    }



    //新闻详情
    public function detailNews() {
        $news_id = Request::param('news_id');
        $data  = Db::name('news')->where(['news_id'=>$news_id])->find();
        if($data !== false){
            return $this->returnJson(Common::changeField($data));
        } else {
            return $this->returnJson();
        }
    }

    //公告详情
    public function detailNotice() {
        $notice_id = Request::param('notice_id');
        $where['notice_id'] = $notice_id;
        $data = Db::name('notice')->where($where)->find();
        return $this->returnJson(Common::changeField($data),'success');
    }


    //公告列表
    public function noticeList() {
        $where['village_id'] = Request::param('village_id');
        $page = Request::param('page',1);
        $data = Db::name('notice')->order(['sort_id'=>'desc','create_time'=>'desc'])->where($where)->field('notice_id,title,author,create_time,content')->page($page,config('app.limit'))->select()->toArray();
        $total = Db::name('notice')->where($where)->count();
        foreach ($data as $k =>$v) {
            $data[$k]['content'] = mb_substr(strip_tags($v['content']),0,100);
        }
        $res['total'] = $total;
        $res['data'] = Common::changeField($data);
        return $this->returnJson($res);
    }













}