<?php


namespace app\api\controller;

use app\common\controller\Common;
use app\BaseController;
use Firebase\JWT\JWT;
use think\facade\Db;
use think\facade\Request;

class Login extends BaseController
{
    //用户登入
    public function login(){
        $phone = Request::param('phone');
        $password = md5(Request::param('password'));
        $code = Request::param('code');

        if($code) {
            //验证短信验证码是否正确
            if(Common::rightCode($phone,$code)){
                $userInfo = Db::name('user')->where(['phone'=>$phone])->find();
                if($userInfo) {
                    if($userInfo['status'] !=1) {
                        return $this->returnJson([],'用户被禁用,请联系管理员!','400');
                    }
                    $uid = $userInfo['uid'];
                } else {
                    //注册
                    $data['phone'] = $phone;
                    $data['nickname'] = substr_replace($phone,"*",3,5);
                    $data['create_time'] =$data['last_time']=time();
                    $data['add_ip'] = $data['last_ip'] = request()->ip();
                    $uid= Db::name('user')->insertGetId($data);
                }
                Common::synUserData($uid,$phone); //同步用户数据
                $token['uid']= $uid;
                $token['time']= date('Y-m-d H:i');
                $token = JWT::encode($token,config('app.jwt_key'));  //根据参数生成了token
                $res['token'] = $token;
                $res['uid'] = $uid;
                $res['phone'] = $phone;
                $res['pwd'] = empty($userInfo['password']) ? 0 :1;
                //查询该用户是否绑定了房间,如果有,则返回上一次绑定的房间
                $userBind  = Db::name('house_user_bind')->where(['uid'=>$uid,'status'=>1,'is_lately_login'=>1])->field('house_user_bind_id,village_id,vacancy_id')->find();
                if($userBind){
                    $res['userBindInfo'] = $userBind;
                } else {
                    //查询是否有房间
                    $userBind  = Db::name('house_user_bind')->where(['uid'=>$uid,'status'=>1])->field('house_user_bind_id,village_id,vacancy_id')->find();
                    if($userBind){
                        $res['userBindInfo'] = $userBind;
                        Db::name('house_user_bind')->where(['uid'=>$uid,'status'=>1])->save(['is_lately_login'=>1]);
                    } else {
                        $res['userBindInfo'] = (Object)[];
                    }
                }

                return $this->returnJson($res);
            } else{
                return $this->returnJson([],'验证码不正确!','400');
            }
        }

        if($password){
            $where['password'] = $password;
            $where['phone'] = $phone;
            $userInfo = Db::name('user')->where($where)->find();
            if($userInfo){
                //更该登入信息
                $data['last_time']=time();
                $data['last_ip'] = request()->ip();
                Db::name('user')->where(['phone'=>$phone])->save($data);
                $token['uid']= $userInfo['uid'];
                $token['time']= date('Y-m-d H:i');
                $token = JWT::encode($token,config('app.jwt_key'));  //根据参数生成了 token
                $res['token'] = $token;
                $res['uid'] = $userInfo['uid'];
                $res['phone'] = $phone;
                $res['pwd'] = empty($userInfo['password']) ? 0 :1;
                Common::synUserData($userInfo['uid'],$phone);
                return $this->returnJson($res,200);
            } else {
                return $this->returnJson([],'密码不正确!','400');
            }
        }
        return $this->returnJson([],'参数错误,请检查!','400');
    }

    //发送短信验证码
    public function sendCode() {
        $phone = Request::param('phone');
        $temp_id = 165103;
        $temp_para['code'] = createPhoneCode(6);
        $client = new \JSMS(config('app.message_appKey'), config('app.message_masterSecret'));
        $res=$client->sendMessage($phone, $temp_id, $temp_para);
        if($res['http_code'] ==200) {
            $data['expires_time'] = time() + 300;
            $data['code'] =   $temp_para['code'] ;
            $data['phone'] = $phone;
            //先删除该手机号的验证码数据,
            Db::name('send_code')->where(['phone'=>$phone])->delete();
            Db::name('send_code')->insert($data);
            return $this->returnJson([]);
        } else {
            $this->returnJson([],'短信验证码发送失败','400');
        }
    }

    //修改|忘记密码
    public function changePassword() {
        if(request()->isPost()) {
            $original_password  = md5(Request::param('original_password'));
            $new_password  = md5(Request::param('new_password'));
            $code  = Request::param('code');
            $phone  = Request::param('phone');
            if($code){
                if(Common::rightCode($phone,$code)){
                    $change = Db::name('user')->where(['phone'=>$phone])->save(['password'=>$new_password]);
                    if($change){
                        return $this->returnJson([]);
                    } else {
                        return $this->returnJson([],'修改失败',400);
                    }
                } else {
                    return $this->returnJson([],"验证码不正确",400);
                }
            } else {
                //验证原密码是否正确
                $is_exit = Db::name('user')->where(['phone'=>$phone,'password'=>$original_password])->find();
                if($is_exit) {
                    $change = Db::name('user')->where(['phone'=>$phone])->save(['password'=>$new_password]);
                    if($change){
                        return $this->returnJson();
                    } else {
                        return $this->returnJson([],'修改失败',400);
                    }
                } else {
                    return $this->returnJson([],'验证码不正确',400);
                }
            }
        } else {
            return $this->returnJson([],'请求方式不正确',400);
        }
    }



}