<?php
namespace app\admin\controller;

use app\api\model\Admin as AdminModel;
use TencentCloud\Cdb\V20170320\Models\VerifyRootAccountRequest;
use think\facade\Db;
use think\facade\Request;


class Index extends Base {

    protected $middleware = ['app\middleware\AdminLoginCheck::class','app\middleware\AdminAfter::class'];
    public function index()
    {
        return "这是admin下的控制器";
    }

    public function hello($name = 'ThinkPHP6')
    {
        return 'hello,' . $name;
    }




    //小区列表
    public  function villageList() {
        //查询,
        $where = [];
        if(Request::param('status')){
            $where[] =  ['ruer_house_village.status','=',Request::param('status')];
        }
        if(Request::param('property_id')){
            $where[] =  ['ruer_house_village.property_id','=',Request::param('property_id')];
        }
        if(Request::param('village_name')){
            $where[]= ['ruer_house_village.village_name','like',"%".Request::param('village_name')."%"];
        }
        if(Request::param('province_id')){
            $where[]= ['ruer_house_village.province_id','=',Request::param('province_id')];

        }
        if(Request::param('city_id')){
            $where[]= ['ruer_house_village.city_id','=',Request::param('city_id')];

        }
        if(Request::param('area_id')){
            $where[]= ['ruer_house_village.area_id','=',Request::param('area_id')];
        }
        $page = Request::param("page",1);
        $count = Db::name('house_village')->alias("hv")->join('ruer_community_admin ca','ca.community_admin_id = hv.community_admin_id')->where($where)->count();

        $data = Db::name('house_village')->alias("hv")->join('ruer_community_admin ca','ca.community_admin_id = hv.community_admin_id')
            ->where($where)
            ->order('hv.create_time','desc')
            ->page($page,config("app.limit"))
            ->field("hv.*,ca.account,ca.status as status_admin,ca.phone")
            ->select()->toArray();

        $res['total'] = $count;
        $res['data'] = Common::changeField($data);

        return $this->returnJson($res,'success');
    }

    //小区详情
    public function  detailVillage() {
        $where['hv.village_id'] = Request::param('village_id');
        if(Request::param('property_id')) {
            $where['hv.property_id'] = Request::param('property_id');
        }
        $data = Db::name('house_village')->alias("hv")->join('community_admin ca','ca.community_admin_id = hv.community_admin_id')->leftJoin('house_property hp','hp.property_id = hv.property_id')
            ->where($where)
            ->field("hv.*,ca.account,ca.status as status_admin,ca.phone,ca.name,hp.property_name,hp.property_id")
            ->find();
        $data= Common::changeField($data);
        return $this->returnJson($data,'success');
    }

    //删除小区
    public function deleteVillage() {
        $id = Request::param('village_id');
        $admin_id = Request::param('admin_id');

        if($admin_id != $this->uid) {
            return $this->returnJson([],'账号异常',400);
        }
        $where['village_id'] = $id;
        $del = Db::name('house_village')->where($where)->delete();
        if($del) {
            Db::name('log')->insert(['explain'=>"管理员_".$admin_id."删除了小区_".$id,'time'=>date('Y-m-d H:i:s',time())]);
            return $this->returnJson([],'success');
        } else {
            return $this->returnJson([],'error',400);
        }
    }


    //物业列表
    public function propertyList() {
        //查询,
        $where[] = ['pa.type','=',1];
        $orwhere = [];
        if(Request::param('status')){
            $where[] =  ['ruer_house_property.status','=',Request::param('status')];
        }
        if(Request::param('property_name')){
            $where[]= ['ruer_house_property.property_name','like',"%".Request::param('property_name')."%"];
            $orwhere[] = ['ruer_house_property.property_phone','like',"%".Request::param('property_name')."%"];
        }

        if(Request::param('province_id')){
            $where[]= ['ruer_house_property.province_id','=',Request::param('province_id')];

        }
        if(Request::param('city_id')){
            $where[]= ['ruer_house_property.city_id','=',Request::param('city_id')];

        }
        if(Request::param('area_id')){
            $where[]= ['ruer_house_property.area_id','=',Request::param('area_id')];
        }

        $page = Request::param("page",1);
        $count = Db::name('house_property')->alias("hp")->join('ruer_property_admin pa','pa.property_admin_id = hp.property_admin_id')->where($where)->whereOr($orwhere)->count();
        $data = Db::name('house_property')->alias("hp")->join('ruer_property_admin pa','pa.property_admin_id = hp.property_admin_id')
            ->where($where)
            ->whereOr($orwhere)
            ->page($page,config('app.limit'))
            ->field("hp.*,pa.account,pa.status as status_admin")
        ->select()->toArray();

        $res['total'] = $count;
        $res['data'] = $data;

        return $this->returnJson($res,'success');

    }


    //修改|添加 物业信息
    public function changeProperty() {

        $property_id = Request::param("property_id");

        $data['property_name']= Request::param("property_name");
        $data['property_phone'] = $save['phone']= Request::param("property_phone");
        $data['property_address'] = Request::param("property_address");
        $data['province_name'] = Request::param("province_name");
        $data['province_id'] = Request::param("province_id");
        $data['city_name'] = Request::param("city_name");
        $data['city_id'] = Request::param("city_id");
        $data['area_name'] = Request::param("area_name");
        $data['area_id'] = Request::param("area_id");
        $save['account'] = Request::param("account");
        $save['create_time'] = $data['create_time'] = time();
        $save['name'] = Request::param("name");
        if(Request::param("password")){
            $save['password'] = md5(Request::param("password"));
        }
        if($property_id) {
            $where['property_id'] = $property_id;
            $op = Db::name('house_property')->where($where)->save($data);
            $property_admin_id = Db::name('house_property')->where($where)->value("property_admin_id");
            $op1 = Db::name('property_admin')->where(['property_admin_id'=>$property_admin_id])->save($save);

            if($op || $op1) {
                return $this->returnJson([],'success');
            } else {
                return $this->returnJson([],'error',400);
            }

        } else {
            //插入物业管理人员表
            Db::startTrans();
            try{
                $save['property_id'] = Db::name('house_property')->insertGetId($data);
                $save['type'] = 1;
                $change['property_admin_id']= Db::name('property_admin')->insertGetId($save);
                Db::name('house_property')->where(['property_id'=>$save['property_id']])->save($change);
                Db::commit();
                return $this->returnJson([],'success');
            }catch(\Exception $e){
                Db::rollback();
                return $this->returnJson([],'error',400);
            }

        }

    }

    //更改物业公司状态
    public function changePropertyStatus() {
        $where['property_id'] = Request::param('property_id');
        $data['status'] = Request::param('status',1);

        $change = Db::name('house_property')->where($where)->update($data);

        if($change) {
            return $this->returnJson([],'success');
        } else {
            return $this->returnJson([],'状态修改失败!',400);
        }

    }


    //删除物业公司
    public function deleteProperty() {
        $id = Request::param('property_id');
        $admin_id = Request::param('admin_id');

        $where['property_id'] = $id;
        //该物业下是否有小区,
        $is_has = Db::name('house_village')->where($where)->find();
        if($is_has) {
            return $this->returnJson([],'该物业下有小区存在,无法删除',400);
        }
        $del = Db::name('house_property')->where($where)->delete();
        if($del) {
            Db::name('log')->insert(['explain'=>"管理员_".$admin_id."删除了物业公司_".$id,'time'=>date('Y-m-d H:i:s',time())]);
            return $this->returnJson([],'success');
        } else {
            return $this->returnJson([],'error',400);
        }
    }

    //查看单个物业公司详情
    public function detailProperty() {
        $where['hp.property_id'] = Request::param('property_id');
        $data = Db::name('house_property')->alias("hp")->join('property_admin pa','pa.property_admin_id = hp.property_admin_id')
            ->where($where)
            ->field("hp.*,pa.account,pa.status as status_admin")
            ->find();
        $data = Common::changeField($data);
        return $this->returnJson($data,'success');

    }




    //查看总后台所有的导航栏
    public function navList() {

        $type = Request::param('type',3); //1:总后台;2:物业后台;3:社区后台
        if($type == 1) {
            $data = Db::name('admin_nav')->where(['admin_nav_status'=>1])->order(['level'=>'asc','sort_id'=>'desc'])->field('admin_nav_id,url,url_name,admin_nav_status,parent_id')->select()->toArray();
            return $this->returnJson($this->getTree($data,0,'admin_nav_id'),'success');
        } elseif($type == 2){
            $data = Db::name('property_nav')->where(['property_nav_status'=>1])->order(['level'=>'asc','sort_id'=>'desc'])->field('property_nav_id,url,url_name,property_nav_status,parent_id')->select()->toArray();
            return $this->returnJson($this->getTree($data,0,'property_nav_id'),'success');
        } else {
            $data = Db::name('community_nav')->where(['community_nav_status'=>1])->order(['level'=>'asc','sort_id'=>'desc'])->field('community_nav_id,url,url_name,community_nav_status,parent_id')->select()->toArray();
            return $this->returnJson($this->getTree($data,0,'community_nav_id'),'success');
        }

    }

    //获取当前导航栏的详情和上一级的详情
    public function detailNav() {
        $type = Request::param('type',3);
        $id = Request::param('id');
        if($type==1) {
            $data = DB::name('admin_nav')->where(['admin_nav_id'=>$id])->find();
            if($data['parent_id'] != 0) {
                $res['p_nav'] = DB::name('admin_nav')->where(['admin_nav_id'=>$data['parent_id']])->field('admin_nav_id,url,url_name,admin_nav_status,level,parent_id,sort_id,icon')->find();
            } else{
                $res['p_nav'] = [];
            }
            $res['nav'] = $data;
        } elseif($type==2) {

            $data = DB::name('property_nav')->where(['property_nav_id'=>$id])->field('property_nav_id,url,url_name,property_nav_status,level,parent_id,sort_id,icon')->find();
            if($data['parent_id'] != 0) {
                $res['p_nav'] = DB::name('property_nav')->where(['property_nav_id'=>$data['parent_id']])->find();
            } else{
                $res['p_nav'] = [];
            }
            $res['nav'] = $data;
        } else {
            $data = DB::name('community_nav')->where(['community_nav_id'=>$id])->field('community_nav_id,url,url_name,community_nav_status,level,parent_id,sort_id,icon')->find();
            if($data['parent_id'] != 0) {
                $res['p_nav'] = DB::name('community_nav')->where(['community_nav_id'=>$data['parent_id']])->find();
            } else{
                $res['p_nav'] = [];
            }
            $res['nav'] = $data;
        }
        return $this->returnJson($res,'success');

    }


    //添加导航栏
    public function addNav() {
        $type = Request::param('type',3); //1:总后台;2:物业后台;3:社区后台
        $data['parent_id'] = Request::param('parent_id',0);
        $data['icon'] = Request::param('icon');
        $data['url'] = Request::param('url','');
        $data['url_name'] = Request::param('url_name');
        $data['sort_id'] = Request::param('sort_id');
        $data['create_time'] = time();

        if($type == 1) {
            $p_info = Db::name('admin_nav')->where(['admin_nav_id'=>$data['parent_id']])->find();
            if($p_info) {
                $data['level'] = $p_info['level'] +1;
            } else {
                $data['level'] =1;
            }
            $data['admin_nav_status'] = 1;
            $add = Db::name('admin_nav')->insert($data);
        } elseif($type == 2) {
            $p_info = Db::name('property_nav')->where(['property_nav_id'=>$data['parent_id']])->find();
            if($p_info) {
                $data['level'] = $p_info['level'] +1;
            } else {
                $data['level'] =1;
            }
            $data['property_nav_status'] = 1;
            $add = Db::name('property_nav')->insert($data);
        } else {
            $p_info = Db::name('community_nav')->where(['community_nav_id'=>$data['parent_id']])->find();
            if($p_info) {
                $data['level'] = $p_info['level'] +1;
            } else {
                $data['level'] =1;
            }
            $data['community_nav_status'] = 1;
            $add = Db::name('community_nav')->insert($data);
        }

        if($add) {
            return $this->returnJson([],'success');
        } else {
            return $this->returnJson([],'error',400);
        }
    }


    //修改导航栏
    public function changeNav() {
        $id = Request::param('id');
        $type = Request::param('type',3);
        $data['url'] = Request::param('url','');
        $data['url_name'] = Request::param('url_name');
        $data['icon'] = Request::param('icon');
        $data['sort_id'] = Request::param('sort_id',1);
        $status = Request::param('status',1);
        if($type ==1) {
            $where['admin_nav_id'] = $id;
            $where['admin_nav_status'] = $status;
            $table="admin_nav";
        } elseif ($type ==2) {
            $where['property_nav_id'] = $id;
            $where['property_nav_status'] = $status;
            $table="property_nav";
        } else {
            $where['community_nav_id'] = $id;
            $where['community_nav_status'] = $status;
            $table="community_nav";
        }
        $change = Db::name($table)->where($where)->save($data);
        if($change) {
            return $this->returnJson([],'success');
        } else {
            return $this->returnJson([],'修改失败!',400);
        }

    }


    //删除导航栏
    public function deleteNav() {
        $id = Request::param('id');
        $type = Request::param('type',3); //1:总后台;2:物业后台;3:社区后台
        //只能删除子导航栏,或者父导航栏没有自导航栏,

        if(!$this->isHasNext($type,$id)) {
            return $this->returnJson([],'删除失败,当前菜单下有子菜单',400);
        }
        if($type==1) {
            $where['admin_nav_id'] = $id;
            $del = Db::name('admin_nav')->where($where)->delete();
        } elseif($type ==2) {
            $where['property_nav_id'] = $id;
            $del = Db::name('property_nav')->where($where)->delete();
        } else {
            $where['community_nav_id'] = $id;
            $del = Db::name('community_nav')->where($where)->delete();
        }
        if($del) {
            return $this->returnJson([],'success');
        } else {
            return $this->returnJson([],'error',400);
        }
    }

    //用来判断导航栏是否存在下一级
    public function isHasNext($type,$id) {

        if($type==1) {
            $is_zi = Db::name('admin_nav')->where(['parent_id'=>$id])->find();
        } elseif($type==2) {
            $is_zi = Db::name('property_nav')->where(['parent_id'=>$id])->find();
        } else{
            $is_zi = Db::name('community_nav')->where(['parent_id'=>$id])->find();
        }
        if($is_zi) {
            return false;
        }
        return true;

    }













}
