<?php
declare (strict_types = 1);

namespace app;

use think\App;
use think\exception\ValidateException;
use think\Response;
use think\Validate;

/**
 * 控制器基础类
 */
abstract class BaseController
{

    protected  $convertArr = [
            "water"  => '水费',
            "property"  => '物业费',
            "electric"  => '电费',
            "gas"  => '燃气费',
            "park"  => '停车费'
        ];

    protected $myUnit = [
        'water' =>"吨",
        'electric' =>'度',
        'gas' =>'立方',
        'property' =>'平方米'
    ];

    protected  $priceUnit = [
        'water' =>"元/吨",
        'electric' =>'元/度',
        'gas' =>'元/立方米',
        'property' =>'元/平方米'
    ];

    protected  $userType = [
        '0' =>'房主',
        '1' =>'家人',
        '2' =>' 租客',
        '3' =>'替换业主'
    ];
    /**
     * Request实例
     * @var \think\Request
     */
    protected $request;

    /**
     * 应用实例
     * @var \think\App
     */
    protected $app;

    /**
     * 是否批量验证
     * @var bool
     */
    protected $batchValidate = false;

    /**
     * 控制器中间件
     * @var array
     */
    protected $middleware = [];

    /**
     * 构造方法
     * @access public
     * @param  App  $app  应用对象
     */
    public function __construct(App $app)
    {
        $this->app     = $app;
        $this->request = $this->app->request;

        // 控制器初始化
        $this->initialize();


    }

    // 初始化,过滤参数
    protected function initialize()
    {
        $is_card = \think\facade\Request::param('id_card');
        if($is_card) {
            if(!isCreditNo($is_card)) {
                echo  json_encode(['code'=>400,'msg'=>'身份证号码不符合!','data'=>[]]);exit;
            }
        }
        $phone = \think\facade\Request::param('phone');
        if($phone) {
            if(!isPhoneNo($phone)) {
                echo  json_encode(['code'=>400,'msg'=>'手机号码不符合!','data'=>[]]);exit;
            }
        }

    }

    /**
     * 验证数据
     * @access protected
     * @param  array        $data     数据
     * @param  string|array $validate 验证器名或者验证规则数组
     * @param  array        $message  提示信息
     * @param  bool         $batch    是否批量验证
     * @return array|string|true
     * @throws ValidateException
     */
    protected function validate(array $data, $validate, array $message = [], bool $batch = false)
    {
        if (is_array($validate)) {
            $v = new Validate();
            $v->rule($validate);
        } else {
            if (strpos($validate, '.')) {
                // 支持场景
                [$validate, $scene] = explode('.', $validate);
            }
            $class = false !== strpos($validate, '\\') ? $validate : $this->app->parseClass('validate', $validate);
            $v     = new $class();
            if (!empty($scene)) {
                $v->scene($scene);
            }
        }

        $v->message($message);

        // 是否批量验证
        if ($batch || $this->batchValidate) {
            $v->batch(true);
        }

        return $v->failException(true)->check($data);
    }

    /**
     *下面是自定义的方法
     */
    //用来返回json数据
    protected  function returnJson($data=[],$msg="success",$code='200',$type="json"){

        $result = [
            'code' => $code,
            'msg'  => $msg,
            'data' => $data,
        ];
        return Response::create($result,$type);

    }

    protected  function returnApiJson($data,$code,$msg=""){

        $result = [
            'code' => $code,

            'data' => $data,

        ];
        return Response::create($result,"json");

    }


    //无限极分类
    public  function getTree($data,$parent_id=0,$pk='id'){
        $tree = array();
        foreach($data as $k => $v)
        {
            if($v['parent_id'] == $parent_id)
            {        //父亲找到儿子
                $v['son'] = self::getTree($data, $v[$pk],$pk);
                $tree[] = $v;
                unset($data[$k]);
            }
        }
        return $tree;
    }

}
